/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;

public class Download
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;
    private URL url;
    private int size;
    private int downloaded;
    private int status;
    private String fileName;

    public Download(URL url) {
        this.url = url;
        this.size = -1;
        this.downloaded = 0;
        this.status = 0;
    }

    public String getUrl() {
        return this.url.toString();
    }

    public int getSize() {
        return this.size;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public int getStatus() {
        return this.status;
    }

    public void pause() {
        this.status = 1;
        this.stateChanged();
    }

    public void resume() {
        this.status = 0;
        this.stateChanged();
        this.download();
    }

    public void cancel() {
        this.status = 3;
        this.stateChanged();
    }

    private void error() {
        this.status = 4;
        this.stateChanged();
    }

    public void download() {
        Thread thread = new Thread(this);
        thread.start();
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void run() {
        block26: {
            RandomAccessFile file = null;
            InputStream stream = null;
            try {
                try {
                    int contentLength;
                    HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                    connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
                    connection.connect();
                    if (connection.getResponseCode() / 100 != 2) {
                        this.error();
                    }
                    if ((contentLength = connection.getContentLength()) < 1) {
                        this.error();
                    }
                    if (this.size == -1) {
                        this.size = contentLength;
                        this.stateChanged();
                    }
                    if (this.fileName == null) {
                        this.fileName = this.getFileName(this.url);
                    }
                    file = new RandomAccessFile(this.fileName, "rw");
                    file.seek(this.downloaded);
                    stream = connection.getInputStream();
                    while (this.status == 0) {
                        byte[] buffer = this.size - this.downloaded > 1024 ? new byte[1024] : new byte[this.size - this.downloaded];
                        int read = stream.read(buffer);
                        if (read == -1) break;
                        file.write(buffer, 0, read);
                        this.downloaded += read;
                        this.stateChanged();
                    }
                    if (this.status == 0) {
                        this.status = 2;
                        this.stateChanged();
                    }
                }
                catch (Exception e) {
                    this.error();
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (stream == null) break block26;
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }
}

