/*
 * Decompiled with CFR 0.152.
 */
package AI;

import AI.Links;
import AI.Node;
import com.badlogic.gdx.graphics.Color;
import data.Coord;
import data.GSB;
import java.util.HashMap;

public class Network {
    HashMap<Coord, Node> nodes = new HashMap();
    Links links = new Links();

    public void add(Node n) {
        this.nodes.put(n.pos, n);
    }

    public void addLink(Coord a, Coord b) {
        this.links.addLink(a, b);
    }

    public void remove(Coord a) {
        if (this.nodes.containsKey(a)) {
            this.nodes.remove(a);
            this.links.remove(a);
        }
    }

    public void renderNetwork(Coord me, Coord you) {
        for (Coord c : this.nodes.keySet()) {
            if (c.equals(you) || c.equals(me)) {
                GSB.srCam.setColor(Color.RED);
            } else {
                GSB.srCam.setColor(Color.BLUE);
            }
            GSB.srCam.circle(c.getX() * 256.0f, c.getY() * 256.0f, 30.0f);
        }
    }

    public void renderLinks() {
        GSB.srCam.setColor(Color.RED);
        this.links.renderLinks();
    }

    public Coord getNearest(float x, float y) {
        Coord mem = null;
        float mindistance = 1.0E7f;
        for (Coord c : this.nodes.keySet()) {
            float distance = c.distanceTo(x, y);
            if (!(distance < mindistance)) continue;
            mindistance = distance;
            mem = c;
        }
        return mem;
    }
}

