/*
 * Decompiled with CFR 0.152.
 */
package AI;

import AI.Node;
import data.Coord;
import data.GSB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Links {
    ArrayList<Link> links = new ArrayList();

    public void addLink(Coord a, Coord b) {
        this.links.add(new Link(a, b));
    }

    public boolean isLinked(Coord a, Coord b) {
        for (Link l : this.links) {
            if (!l.linked(a, b)) continue;
            return true;
        }
        return false;
    }

    public void remove(Coord a) {
        int i = 0;
        while (i < this.links.size()) {
            if (this.links.get(i).hasNode(a)) {
                this.links.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void renderLinks() {
        for (Link l : this.links) {
            GSB.srCam.line(l.a.getX() * 256.0f, l.a.getY() * 256.0f, l.b.getX() * 256.0f, l.b.getY() * 256.0f);
        }
    }

    public Set<Coord> getLinks(Coord pos) {
        HashSet<Coord> toReturn = new HashSet<Coord>();
        for (Link l : this.links) {
            if (l.a.equals(pos)) {
                toReturn.add(l.b);
            }
            if (!l.b.equals(pos)) continue;
            toReturn.add(l.a);
        }
        return toReturn;
    }

    public void clear(HashMap<Coord, Node> nodes) {
        int i = 0;
        while (i < this.links.size()) {
            Link l = this.links.get(i);
            if (nodes.get(l.a) == null || nodes.get(l.b) == null) {
                this.links.remove(i);
                --i;
            }
            ++i;
        }
    }

    class Link {
        Coord a;
        Coord b;

        public Link(Coord a, Coord b) {
            this.a = a;
            this.b = b;
        }

        public boolean linked(Coord c, Coord d) {
            return this.a.equals(c) && this.b.equals(d) || this.a.equals(d) && this.b.equals(c);
        }

        public boolean hasNode(Coord c) {
            return this.a.equals(c) || this.b.equals(c);
        }
    }
}

