/*
 * Decompiled with CFR 0.152.
 */
package AI;

import AI.Network;
import AI.Node;
import AI.Path;
import AI.Pathfinding;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Polygon;
import data.Coord;
import data.GSB;
import game.Personnage;
import java.util.HashSet;
import map.Block;
import map.Map;
import screens.Game;
import screens.Options;

public class AI {
    float middlex = 0.0f;
    Network n;
    boolean once = true;
    Coord abc;
    Coord def;
    Path lastPath;
    float random;
    float randomcount = 1.0f;

    public AI(Map m) {
        this.generateNetwork();
        for (Block b : m.getBlocks()) {
            this.n.remove(b.pos);
        }
        HashSet<Coord> toRemove = new HashSet<Coord>();
        for (Coord c : this.n.nodes.keySet()) {
            boolean remove = true;
            for (Block b : m.getBlocks()) {
                if (b.getX() != c.getX() || !(c.getY() >= b.getY())) continue;
                remove = false;
            }
            if (!remove) continue;
            toRemove.add(new Coord(c));
        }
        for (Coord c : toRemove) {
            this.n.remove(c);
        }
    }

    public void generateNetwork() {
        float y;
        boolean extend = true;
        this.n = new Network();
        float x = Game.getMinx() - (float)extend;
        while (x <= Game.getMaxx() + (float)extend) {
            y = Game.getMiny() - (float)extend;
            while (y <= Game.getMaxy() + (float)extend + 5.0f) {
                this.n.add(new Node(x, y));
                y += 1.0f;
            }
            x += 1.0f;
        }
        x = Game.getMinx() - (float)extend;
        while (x <= Game.getMaxx() + (float)extend) {
            y = Game.getMiny() - (float)extend;
            while (y <= Game.getMaxy() + (float)extend + 5.0f) {
                this.n.addLink(new Coord(x, y), new Coord(x + 1.0f, y));
                this.n.addLink(new Coord(x, y), new Coord(x - 1.0f, y));
                this.n.addLink(new Coord(x, y), new Coord(x, y + 1.0f));
                this.n.addLink(new Coord(x, y), new Coord(x, y - 1.0f));
                y += 1.0f;
            }
            x += 1.0f;
        }
        this.n.links.clear(this.n.nodes);
    }

    public void update(Personnage me, Personnage enemy, float delta) {
        if (Options.get("advancedIA")) {
            this.smartAI(me, enemy, delta);
        } else {
            this.dumbAI(me, enemy, delta);
        }
        if (Math.abs(me.getY() - enemy.getY()) < 200.0f) {
            me.fire();
        }
    }

    private void smartAI(Personnage me, Personnage enemy, float delta) {
        Coord mepos = this.n.getNearest(me.getX() / 256.0f, me.getY() / 256.0f);
        Coord youpos = this.n.getNearest(enemy.getX() / 256.0f, enemy.getY() / 256.0f);
        if (!mepos.equals(this.abc) || !youpos.equals(this.def)) {
            this.lastPath = Pathfinding.getPath(mepos, youpos, this.n.nodes, this.n.links);
            this.abc = mepos;
            this.def = youpos;
        }
        if (this.lastPath != null) {
            Coord toGo = this.lastPath.getCoord(1);
            if (toGo.getY() * 256.0f - 128.0f > me.getY() && me.jumps != 1) {
                me.jump();
            }
            if (toGo.getX() * 256.0f < me.getX()) {
                me.move(false, delta);
            }
            if (toGo.getX() * 256.0f > me.getX()) {
                me.move(true, delta);
            }
            if (!me.onGround() && Math.abs(me.getVy()) < 1.0f && toGo.getY() * 256.0f - 128.0f > me.getY() || this.isInTheAir(me)) {
                me.jump();
            }
        } else {
            this.dumbAI(me, enemy, delta);
        }
    }

    public void renderPath() {
        if (this.lastPath == null) {
            return;
        }
        GSB.srCam.begin(ShapeRenderer.ShapeType.Line);
        GSB.srCam.setColor(Color.BLACK);
        this.n.renderLinks();
        GSB.srCam.end();
        GSB.srCam.begin(ShapeRenderer.ShapeType.Filled);
        this.n.renderNetwork(this.abc, this.def);
        this.lastPath.renderPath();
        GSB.srCam.end();
    }

    private boolean isInTheAir(Personnage pers) {
        for (Polygon p : pers.getCollisions()) {
            float x = pers.getX();
            if (!(x > p.getX()) || !(x < p.getX() + 256.0f)) continue;
            return false;
        }
        return true;
    }

    private void iDontKnowWhatToDo(Personnage me, Personnage enemy, float delta) {
        me.jump();
        if (this.middlex > me.getX()) {
            me.move(true, delta);
        } else {
            me.move(false, delta);
        }
    }

    private void dumbAI(Personnage me, Personnage enemy, float delta) {
        this.randomcount -= delta;
        if (this.randomcount < 0.0f) {
            this.random = (float)Math.random();
            this.randomcount = 1.0f;
        }
        if (this.isInTheAir(enemy)) {
            this.iDontKnowWhatToDo(me, enemy, delta);
        } else if (Math.abs(me.getX() - enemy.getX()) > this.random * 300.0f) {
            if (enemy.getX() > me.getX()) {
                me.move(true, delta);
            }
            if (enemy.getX() < me.getX()) {
                me.move(false, delta);
            }
        } else {
            if (enemy.getX() > me.getX()) {
                me.move(false, delta);
            }
            if (enemy.getX() < me.getX()) {
                me.move(true, delta);
            }
        }
        if (enemy.getY() > me.getY() + 10.0f && !me.jumping || this.isInTheAir(me)) {
            me.jump();
        }
        if (!me.onGround() && Math.abs(me.getVy()) < 1.0f && enemy.getY() > me.getY() + 10.0f) {
            me.jump();
        }
    }
}

