/*
 * Decompiled with CFR 0.152.
 */
package weapons;

import com.badlogic.gdx.graphics.Texture;
import data.SoundManager;
import entities.Bullet;
import java.util.ArrayList;
import screens.Game;
import screens.Options;
import weapons.BulletWeapon;

public class Shotgun
extends BulletWeapon {
    public Shotgun() {
        this.setName("Shotgun");
        this.setPath("Armes/shotgun.png");
        this.setRate(60);
        this.setPadding(27, 8);
        this.setMaxAmmo(35);
        this.setVelocity(30);
        this.setDamage(3);
        if (!Options.get("brawl")) {
            this.setDamage(7);
        }
        this.setRecoil(15.0f);
        this.setVelocityScale(0.7f);
    }

    @Override
    protected ArrayList<Bullet> getFiredBullets(Texture text) {
        ArrayList<Bullet> fired = new ArrayList<Bullet>();
        fired.add(new Bullet(this.owner.getX() + (float)this.paddingx, this.owner.getY() + (float)this.paddingy + (float)(text.getHeight() / 2) + 5.0f, this.velocity, 5.0f, this.damage, this.velocityScale, this.owner.id));
        fired.add(new Bullet(this.owner.getX() + (float)this.paddingx, this.owner.getY() + (float)this.paddingy + (float)(text.getHeight() / 2) + 5.0f, this.velocity, 0.0f, this.damage, this.velocityScale, this.owner.id));
        fired.add(new Bullet(this.owner.getX() + (float)this.paddingx, this.owner.getY() + (float)this.paddingy + (float)(text.getHeight() / 2) + 5.0f, this.velocity, -5.0f, this.damage, this.velocityScale, this.owner.id));
        return fired;
    }

    @Override
    public void onReload() {
    }

    @Override
    public void onFire() {
        if (Options.get("sound")) {
            if (Game.isGameSlowed()) {
                SoundManager.get("shotgun.ogg").play(1.0f, 0.5f, 0.0f);
            } else {
                SoundManager.get("shotgun.ogg").play();
            }
        }
    }
}

