/*
 * Decompiled with CFR 0.152.
 */
package weapons;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import data.GSB;
import data.SpriteManager;

public class OldBullet {
    float x;
    float y;
    float vx;
    float vy;
    Rectangle hitbox;
    int dmg;
    float angle;
    Sprite image;

    public OldBullet(float x, float y, float vx, float vy, int dmg) {
        this.dmg = dmg;
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.image = SpriteManager.get("Armes/bullet.png");
        this.image.setOrigin(this.image.getWidth() / 2.0f, this.image.getHeight() / 2.0f);
        this.angle = this.getAngle(vx, vy);
    }

    private float getAngle(float vx, float vy) {
        float angle = (float)Math.toDegrees(Math.acos((double)vx / Math.sqrt(vx * vx + vy * vy)));
        if (vy < 0.0f) {
            angle = -angle;
        }
        return angle;
    }

    public void update(float delta) {
        this.x += this.vx * (delta * 60.0f);
        this.y += this.vy * (delta * 60.0f);
    }

    public Vector2[] getCollision(float delta) {
        Vector2[] collision;
        collision = new Vector2[]{this.vx > 0.0f ? new Vector2(this.x + this.image.getWidth() - 30.0f, this.y + this.image.getHeight() / 2.0f) : new Vector2(this.x + 30.0f, this.y + this.image.getHeight() / 2.0f), new Vector2(collision[0].x + this.vx * delta * 60.0f, collision[0].y + this.vy * delta * 60.0f)};
        return collision;
    }

    public void render() {
        this.image.setRotation(this.angle);
        this.image.setPosition(this.x, this.y);
        this.image.draw(GSB.sb);
    }

    public int getDmg() {
        return this.dmg;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }
}

