/*
 * Decompiled with CFR 0.152.
 */
package weapons;

import com.badlogic.gdx.graphics.Texture;
import data.TextureManager;
import entities.Bullet;
import java.util.ArrayList;
import screens.Options;
import weapons.Weapon;

public class BulletWeapon
extends Weapon {
    int fireRate = 3;
    float lastFire = 0.0f;
    int damage;
    int velocity;
    static int minX;
    static int maxX;
    float velocityScale = 1.5f;
    float recoil = 10.0f;
    boolean once;

    public void setRate(int rate) {
        this.fireRate = rate;
    }

    public float getLastFire() {
        if (this.lastFire < 0.0f) {
            return 0.0f;
        }
        return this.lastFire;
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public static void setMinMaxX(int minx, int maxx) {
        minX = minx;
        maxX = maxx;
    }

    public void setRecoil(float recoil) {
        this.recoil = recoil;
    }

    public boolean canShoot() {
        return this.lastFire <= 0.0f;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public void fire() {
        this.lastFire = this.fireRate;
        Texture text = TextureManager.get(this.path);
        if (Options.get("ammo")) {
            this.setAmmo(this.ammo - 1);
        }
        if (this.ammo < 0) {
            this.setAmmo(0);
        } else {
            float recoil = this.recoil;
            if (!this.owner.onGround()) {
                recoil *= 0.7f;
            }
            if (this.owner.getDirection()) {
                this.owner.setVx(this.owner.getVx() - recoil);
            } else {
                this.owner.setVx(this.owner.getVx() + recoil);
            }
            for (Bullet b : this.getFiredBullets(text)) {
                if (!this.owner.getDirection()) {
                    b.inverteVx();
                    b.setX(b.getX() - (this.owner.getHitbox().width + (float)text.getWidth() - 20.0f));
                }
                this.owner.g.we.addEntity(b);
                this.onFire();
            }
        }
    }

    protected ArrayList<Bullet> getFiredBullets(Texture text) {
        ArrayList<Bullet> toShoot = new ArrayList<Bullet>();
        toShoot.add(new Bullet(this.owner.getX() + (float)this.paddingx, this.owner.getY() + (float)this.paddingy + (float)(text.getHeight() / 2) + 5.0f, this.velocity, 0.0f, this.damage, this.velocityScale, this.owner.id));
        return toShoot;
    }

    @Override
    public void update(float delta) {
        this.lastFire -= 1.0f * delta * 60.0f;
        if (this.lastFire > 20.0f) {
            this.once = true;
        }
        if (this.lastFire <= 20.0f && this.once) {
            this.once = false;
            this.onReload();
        }
    }

    public void setVelocityScale(float velocityScale) {
        this.velocityScale = velocityScale;
    }

    public void onFire() {
    }

    public void onReload() {
    }

    @Override
    public void reset() {
        this.lastFire = 0.0f;
        this.ammo = this.maxammo;
    }
}

