/*
 * Decompiled with CFR 0.152.
 */
package ui_buttons;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import data.FontManager;
import data.GSB;
import data.TextureManager;
import java.util.regex.Pattern;

public class TextInput
implements InputProcessor {
    int x = 0;
    int originalY = 0;
    int drawy;
    int width;
    int height;
    String toShowWhenEmpty;
    boolean writing = false;
    String current = "";
    String regexLimit = "";
    float time = 0.0f;
    boolean update = true;
    GlyphLayout gl = new GlyphLayout();

    public TextInput(String text) {
        this.toShowWhenEmpty = text;
        this.width = 300;
        this.height = 50;
    }

    public void setRegex(String regexLimit) {
        this.regexLimit = regexLimit;
    }

    public String getText() {
        return this.current;
    }

    public void render(int scroll) {
        this.time = System.nanoTime() / 100000000L;
        System.out.print(String.valueOf(this.time) + "\r");
        this.drawy = this.originalY + scroll;
        String path = "textinput.png";
        GSB.hud.draw(TextureManager.get(path), (float)this.x, (float)this.drawy);
        if (!this.writing && this.current.equals("")) {
            this.gl.setText(FontManager.get(20), this.toShowWhenEmpty);
            FontManager.get(20).draw((Batch)GSB.hud, this.toShowWhenEmpty, (float)this.x + ((float)this.width - this.gl.width) / 2.0f, (float)(15 + this.drawy) + ((float)this.height - this.gl.height) / 2.0f);
        } else {
            this.gl.setText(FontManager.get(20), this.current);
            FontManager.get(20).draw((Batch)GSB.hud, this.current, (float)(this.x + 10), (float)this.drawy + ((float)this.height + this.gl.height) / 2.0f);
        }
        if (this.writing && Math.sin(this.time / 2.0f) > 0.0) {
            FontManager.get(20).draw((Batch)GSB.hud, "|", (float)(this.x + 10) + this.gl.width, (float)this.drawy + ((float)this.height + this.gl.height) / 2.0f);
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.originalY = y;
        this.drawy = y;
    }

    public void center(boolean x, boolean y) {
        if (x) {
            this.x -= this.width / 2;
        }
        if (y) {
            this.originalY -= this.height / 2;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.drawy;
    }

    boolean contains(int x, int y) {
        return x > this.x && y > this.drawy && x < this.x + this.width && y < this.drawy + this.height;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    @Override
    public boolean keyTyped(char character) {
        if (this.update) {
            this.gl.setText(FontManager.get(20), String.valueOf(this.current) + " " + character);
            boolean catchRegex = true;
            if (this.regexLimit != "") {
                catchRegex = Pattern.matches(this.regexLimit, "" + character);
            }
            if (catchRegex & this.writing && this.gl.width < (float)(this.width - 15)) {
                this.current = String.valueOf(this.current) + character;
            }
        }
        return this.writing;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        screenY = Gdx.graphics.getHeight() - screenY;
        if (button == 0 && this.contains(screenX, screenY)) {
            this.setWriting(true);
        } else {
            this.setWriting(false);
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        this.contains(screenX, Gdx.graphics.getHeight() - screenY);
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.update && keycode == 67 && !this.current.equals("")) {
            this.current = this.current.substring(0, this.current.length() - 1);
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    public void reset() {
        this.current = "";
    }

    public void setUpdate(boolean b) {
        this.update = b;
    }
}

