/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import data.GSB;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import screens.MainMenu;
import ui_buttons.BigButton;
import ui_buttons.OptionsButton;

public class Options
implements Screen {
    OptionsButton ammo;
    OptionsButton brawl;
    OptionsButton IA;
    OptionsButton parkour;
    OptionsButton music;
    OptionsButton sound;
    OptionsButton advancedIA;
    BigButton exit;
    public static Properties p = new Properties();

    public Options() {
        Options.loadProperties();
        this.ammo = new OptionsButton("Ammo : ");
        this.ammo.setLocation(Gdx.graphics.getWidth() / 2, Gdx.graphics.getHeight() / 2 + 200);
        this.ammo.setActivated(Options.get("ammo"));
        this.brawl = new OptionsButton("Brawl : ");
        this.brawl.setLocation(this.ammo.getX(), this.ammo.getY() - this.ammo.getHeight() * 2);
        this.brawl.setActivated(Options.get("brawl"));
        this.IA = new OptionsButton("AI : ");
        this.IA.setLocation(this.brawl.getX(), this.brawl.getY() - this.brawl.getHeight() * 2);
        this.IA.setActivated(Options.get("IA"));
        this.advancedIA = new OptionsButton("Advanced AI : ");
        this.advancedIA.setLocation(this.IA.getX(), this.IA.getY() - this.IA.getHeight() * 2);
        this.advancedIA.setActivated(Options.get("advancedIA"));
        this.parkour = new OptionsButton("Parkour : ");
        this.parkour.setLocation(this.advancedIA.getX(), this.advancedIA.getY() - this.advancedIA.getHeight() * 2);
        this.parkour.setActivated(Options.get("parkour"));
        this.music = new OptionsButton("Music : ");
        this.music.setLocation(Gdx.graphics.getWidth() * 3 / 4, this.brawl.getY());
        this.music.setActivated(Options.get("music"));
        this.sound = new OptionsButton("Sound : ");
        this.sound.setLocation(this.music.getX(), this.music.getY() - this.music.getHeight() * 2);
        this.sound.setActivated(Options.get("sound"));
        this.exit = new BigButton("Back to main menu"){

            @Override
            protected void onClick() {
                p.setProperty("ammo", Options.this.ammo.getValue() ? "true" : "false");
                p.setProperty("brawl", Options.this.brawl.getValue() ? "true" : "false");
                p.setProperty("IA", Options.this.IA.getValue() ? "true" : "false");
                p.setProperty("advancedIA", Options.this.advancedIA.getValue() ? "true" : "flse");
                p.setProperty("parkour", Options.this.parkour.getValue() ? "true" : "false");
                p.setProperty("music", Options.this.music.getValue() ? "true" : "false");
                p.setProperty("sound", Options.this.sound.getValue() ? "true" : "false");
                try {
                    PrintWriter pw = new PrintWriter(Gdx.files.internal("settings.properties").file());
                    pw.write("");
                    pw.close();
                    p.store(new FileOutputStream(Gdx.files.internal("settings.properties").file()), "SupergunArena properties");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ((Game)Gdx.app.getApplicationListener()).setScreen(new MainMenu());
            }
        };
        this.exit.setLocation(Gdx.graphics.getWidth() / 2, this.parkour.getY() - this.parkour.getHeight() * 2);
        this.exit.center(true, false);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        GSB.hud.begin();
        this.ammo.render();
        this.brawl.render();
        this.exit.render(0);
        this.IA.render();
        this.advancedIA.render();
        this.parkour.render();
        this.music.render();
        this.sound.render();
        GSB.hud.end();
        this.update(delta);
    }

    public void update(float delta) {
        this.ammo.update();
        this.brawl.update();
        this.IA.update();
        this.exit.update();
        this.parkour.update();
        this.music.update();
        this.sound.update();
        this.advancedIA.update();
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private static void forceNewProperties() throws IOException {
        Gdx.files.internal("settings.properties").file().createNewFile();
        p.setProperty("ammo", "false");
        p.setProperty("brawl", "true");
        p.setProperty("IA", "false");
        p.setProperty("parkour", "false");
        p.setProperty("music", "true");
        p.setProperty("sound", "true");
        p.setProperty("advancedIA", "false");
        p.store(new FileOutputStream(Gdx.files.internal("settings.properties").file()), "SupergunArena properties");
    }

    private static void loadProperties() {
        try {
            if (Gdx.files.internal("settings.properties").exists()) {
                p.load(Gdx.files.internal("settings.properties").read());
            } else {
                Options.forceNewProperties();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean get(String string) {
        if (p.get(string) == null) {
            Options.loadProperties();
        }
        if (p.get(string) == null) {
            try {
                Options.forceNewProperties();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return p.get(string).equals("true");
    }
}

