/*
 * Decompiled with CFR 0.152.
 */
package screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import data.Coord;
import data.GSB;
import data.MapManager;
import data.SpriteManager;
import data.TextureManager;
import java.awt.Point;
import java.util.ArrayList;
import map.Block;
import map.Map;
import screens.Game;
import screens.MapMenu;
import screens.Options;
import ui_buttons.BigButton;
import ui_buttons.ScrollClass;

public class Editor
implements Screen {
    Map map;
    BigButton save;
    BigButton exit;
    BigButton changemode;
    BigButton parkour;
    Sprite gentil;
    Sprite mechant;
    Sprite normalBlock;
    Sprite voidBlock;
    int blockSize = 60;
    Point lastClick = new Point(0, 0);
    int type = 0;
    boolean dragging;
    int whichone;
    Pixmap delete;
    boolean deletemode = false;

    public Editor(final String mapName) {
        this.map = MapManager.load(mapName);
        this.map.computeTypes();
        Game.camera.zoom = 2.0f;
        this.gentil = new Sprite(SpriteManager.get("Gentil/gauche2.png"));
        this.gentil.setPosition(this.map.getGentilPos().getX(), this.map.getGentilPos().getY());
        this.gentil.flip(true, false);
        this.mechant = new Sprite(SpriteManager.get("Mechant/gauche2.png"));
        this.mechant.setPosition(this.map.getMechantPos().getX(), this.map.getMechantPos().getY());
        this.delete = TextureManager.getPixmap("delete.png");
        this.normalBlock = new Sprite(SpriteManager.get("sol.png"));
        this.voidBlock = new Sprite(SpriteManager.get("void.png"));
        this.normalBlock.setSize(this.blockSize - 10, this.blockSize - 10);
        this.voidBlock.setSize(this.blockSize + 10, this.blockSize + 10);
        this.normalBlock.setCenterX((float)(Gdx.graphics.getWidth() / 2) - this.normalBlock.getWidth() / 2.0f - 20.0f);
        this.normalBlock.setY((float)Gdx.graphics.getHeight() - this.normalBlock.getHeight() - 5.0f);
        this.voidBlock.setCenterX((float)(Gdx.graphics.getWidth() / 2) + this.voidBlock.getWidth() / 2.0f + 10.0f);
        this.voidBlock.setY((float)Gdx.graphics.getHeight() - this.normalBlock.getHeight() - 15.0f);
        this.save = new BigButton("Save"){

            @Override
            protected void onClick() {
                Editor.this.map.setPlayersPosition(new Coord((int)Editor.this.gentil.getX(), (int)Editor.this.gentil.getY()), new Coord((int)Editor.this.mechant.getX(), (int)Editor.this.mechant.getY()));
                MapManager.save(Editor.this.map, mapName);
            }
        };
        this.save.setLocation(Gdx.graphics.getWidth() / 2, 0);
        this.save.center(true, false);
        this.exit = new BigButton("Exit"){

            @Override
            protected void onClick() {
                Gdx.input.setCursorImage(null, 0, 0);
                Game.resetCamera();
                GSB.update(Game.camera);
                ((com.badlogic.gdx.Game)Gdx.app.getApplicationListener()).setScreen(new MapMenu());
            }
        };
        this.exit.setLocation(Gdx.graphics.getWidth() - this.exit.getWidth(), 0);
        this.changemode = new BigButton("Switch mode"){

            @Override
            protected void onClick() {
                boolean bl = Editor.this.deletemode = !Editor.this.deletemode;
                if (Editor.this.deletemode) {
                    Gdx.input.setCursorImage(Editor.this.delete, 16, 16);
                } else {
                    Gdx.input.setCursorImage(null, 0, 0);
                }
            }
        };
        this.changemode.setLocation(0, 0);
        this.parkour = new BigButton("Generate parkour"){

            @Override
            protected void onClick() {
                Editor.this.map = MapManager.generateParkour();
                Editor.this.map.computeTypes();
            }
        };
        this.parkour.setLocation(0, Gdx.graphics.getHeight() - this.changemode.getHeight());
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.map.render(delta);
        GSB.sb.begin();
        this.gentil.draw(GSB.sb);
        this.mechant.draw(GSB.sb);
        GSB.sb.end();
        float x = (float)Gdx.input.getX() * Game.camera.zoom - (float)Gdx.graphics.getWidth() * Game.camera.zoom / 2.0f;
        float y = (float)(Gdx.graphics.getHeight() - Gdx.input.getY()) * Game.camera.zoom - (float)Gdx.graphics.getHeight() * Game.camera.zoom / 2.0f;
        x += Game.camera.position.x;
        y += Game.camera.position.y;
        if (x < 0.0f) {
            x -= 256.0f;
        }
        if (y < 0.0f) {
            y -= 256.0f;
        }
        int gridx = (int)(x / 256.0f);
        int gridy = (int)(y / 256.0f);
        if (x < 0.0f) {
            x += 256.0f;
        }
        if (y < 0.0f) {
            y += 256.0f;
        }
        if (!this.anythingElseIsHovered(x, y)) {
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            GSB.srCam.begin(ShapeRenderer.ShapeType.Filled);
            if (this.deletemode) {
                GSB.srCam.setColor(1.0f, 0.0f, 0.0f, 0.2f);
            } else {
                GSB.srCam.setColor(0.9f, 0.9f, 0.9f, 0.3f);
            }
            GSB.srCam.rect(gridx * 256, gridy * 256, 256.0f, 256.0f);
            GSB.srCam.end();
            Gdx.gl.glDisable(3042);
        }
        GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        GSB.srHud.setColor(0.7f, 0.7f, 0.7f, 0.7f);
        GSB.srHud.rect(Gdx.graphics.getWidth() / 2 - this.blockSize * 2, Gdx.graphics.getHeight() - this.blockSize, this.blockSize * 4, this.blockSize);
        GSB.srHud.triangle(Gdx.graphics.getWidth() / 2 - this.blockSize * 2 - 30, Gdx.graphics.getHeight(), Gdx.graphics.getWidth() / 2 - this.blockSize * 2, Gdx.graphics.getHeight(), Gdx.graphics.getWidth() / 2 - this.blockSize * 2, Gdx.graphics.getHeight() - this.blockSize);
        GSB.srHud.triangle(Gdx.graphics.getWidth() / 2 + this.blockSize * 2 + 30, Gdx.graphics.getHeight(), Gdx.graphics.getWidth() / 2 + this.blockSize * 2, Gdx.graphics.getHeight(), Gdx.graphics.getWidth() / 2 + this.blockSize * 2, Gdx.graphics.getHeight() - this.blockSize);
        GSB.srHud.setColor(0.3f, 0.3f, 0.3f, 0.2f);
        if (this.type == 0) {
            GSB.srHud.rect(this.normalBlock.getX() - 5.0f, this.normalBlock.getY() - 5.0f, this.normalBlock.getWidth() + 10.0f, this.normalBlock.getHeight() + 10.0f);
        }
        if (this.type == 1) {
            GSB.srHud.rect(this.normalBlock.getX() + 83.0f, this.normalBlock.getY() - 5.0f, this.normalBlock.getWidth() + 10.0f, this.normalBlock.getHeight() + 10.0f);
        }
        GSB.srHud.end();
        GSB.hud.begin();
        this.save.render(0);
        this.exit.render(0);
        this.changemode.render(0);
        if (Options.get("parkour")) {
            this.parkour.render(0);
        }
        this.normalBlock.draw(GSB.hud);
        this.voidBlock.draw(GSB.hud);
        GSB.hud.end();
        this.update(delta, gridx, gridy, x, y);
    }

    public boolean anythingElseIsHovered(float x, float y) {
        if (this.parkour.isHovered() || this.changemode.isHovered() || this.save.isHovered() || this.gentil.getBoundingRectangle().contains(x, y) || this.mechant.getBoundingRectangle().contains(x, y)) {
            return true;
        }
        if (this.normalBlock.getBoundingRectangle().contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY())) {
            return true;
        }
        return this.voidBlock.getBoundingRectangle().contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY());
    }

    private boolean alreadyBlocked(int x, int y, int type) {
        for (Block c : this.map.getBlocks()) {
            if (c.getX() != (float)x || c.getY() != (float)y || c.getType() != type) continue;
            return true;
        }
        return false;
    }

    public void update(float delta, int gridx, int gridy, float x, float y) {
        if (Gdx.input.isButtonPressed(1) && !Gdx.input.justTouched()) {
            Game.camera.translate((float)(this.lastClick.x - Gdx.input.getX()) * Game.camera.zoom, 0.0f);
            this.lastClick.x = Gdx.input.getX();
            Game.camera.translate(0.0f, (float)(Gdx.input.getY() - this.lastClick.y) * Game.camera.zoom);
            this.lastClick.y = Gdx.input.getY();
        }
        if (Gdx.input.isButtonPressed(1) && Gdx.input.justTouched()) {
            this.lastClick.x = Gdx.input.getX();
            this.lastClick.y = Gdx.input.getY();
        }
        if (Gdx.input.isButtonPressed(0) && Gdx.input.justTouched()) {
            if (this.normalBlock.getBoundingRectangle().contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY())) {
                this.type = 0;
            }
            if (this.voidBlock.getBoundingRectangle().contains(Gdx.input.getX(), Gdx.graphics.getHeight() - Gdx.input.getY())) {
                this.type = 1;
            }
        }
        if (Gdx.input.isButtonPressed(0) && !this.anythingElseIsHovered(x, y) && !this.dragging) {
            ArrayList<Block> mapBlocks = this.map.getBlocks();
            if (this.deletemode) {
                int i = 0;
                while (i < mapBlocks.size()) {
                    Block c = mapBlocks.get(i);
                    if (c.getX() == (float)gridx && c.getY() == (float)gridy) {
                        mapBlocks.remove(i);
                    }
                    ++i;
                }
            } else if (this.type == 0) {
                if (!this.alreadyBlocked(gridx, gridy, this.type)) {
                    this.map.addBox(new Coord(gridx, gridy), this.type);
                }
            } else {
                this.map.addBox(new Coord(gridx, gridy), this.type);
            }
            this.map.computeTypes();
        }
        if (this.dragging) {
            if (this.whichone == 0) {
                this.gentil.setPosition(x - 50.0f, y - 50.0f);
            }
            if (this.whichone == 1) {
                this.mechant.setPosition(x - 50.0f, y - 50.0f);
            }
        }
        if (Gdx.input.isButtonPressed(0)) {
            if (this.gentil.getBoundingRectangle().contains(x, y)) {
                this.dragging = true;
                this.whichone = 0;
            }
            if (this.mechant.getBoundingRectangle().contains(x, y)) {
                this.dragging = true;
                this.whichone = 1;
            }
        } else {
            this.dragging = false;
        }
        if (Gdx.input.isKeyPressed(50)) {
            this.map.getBlocks().clear();
        }
        if (Gdx.input.isKeyJustPressed(8)) {
            this.type = 0;
        }
        if (Gdx.input.isKeyJustPressed(9)) {
            this.type = 1;
        }
        this.save.update();
        this.exit.update();
        this.changemode.update();
        if (Options.get("parkour")) {
            this.parkour.update();
        }
        Game.camera.zoom += (float)ScrollClass.getScroll() / 5.0f;
        Game.camera.update();
        GSB.update(Game.camera);
    }

    @Override
    public void show() {
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }
}

