/*
 * Decompiled with CFR 0.152.
 */
package particles;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import data.GSB;
import java.util.ArrayList;
import particles.Particle;

public class ParticleEmitter {
    int x;
    int y;
    int rate = 1;
    float power;
    boolean emitting = false;
    ArrayList<Particle> particles = new ArrayList();
    float gravity = 0.0f;
    float life = 3.0f;
    float emitTime = 1000.0f;
    Color forced = null;
    String texture = "";

    public ParticleEmitter(int x, int y, float power) {
        this.x = x;
        this.y = y;
        this.power = power;
    }

    public void startEmitting() {
        this.emitting = true;
        this.emitTime = 1000.0f;
    }

    public void startEmitting(float time) {
        this.emitting = true;
        this.emitTime = time;
    }

    public void enableGravity(float gravity) {
        this.gravity = gravity;
    }

    public void stopEmitting() {
        this.emitting = false;
    }

    public void setForcedColor(Color forced) {
        this.forced = forced;
    }

    public void setLife(float life) {
        this.life = life;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setTexture(String path) {
        this.texture = path;
    }

    public void update(float delta) {
        int i;
        this.emitTime -= delta;
        if (this.emitTime <= 0.0f) {
            this.emitting = false;
        }
        if (this.emitting) {
            i = 0;
            while (i < this.rate) {
                Particle toAdd = new Particle(this.x, this.y);
                toAdd.setColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f));
                float angle = (float)(Math.random() * Math.PI * 2.0);
                float tmpPower = this.power;
                tmpPower = (float)((double)tmpPower * (Math.random() + 0.5));
                toAdd.setSpeed((float)(Math.cos(angle) * (double)tmpPower), (float)(Math.sin(angle) * (double)tmpPower));
                toAdd.enableGravity(this.gravity);
                toAdd.setLife(this.life);
                if (this.texture != "") {
                    toAdd.setTexture(this.texture);
                }
                if (this.forced != null) {
                    toAdd.c = this.forced;
                }
                this.particles.add(toAdd);
                ++i;
            }
        }
        i = 0;
        while (i < this.particles.size()) {
            if (this.particles.get(i).dieCondition()) {
                this.particles.remove(i);
            }
            ++i;
        }
        for (Particle p : this.particles) {
            p.updateParticle(delta);
        }
    }

    public void render() {
        GSB.srCam.begin(ShapeRenderer.ShapeType.Filled);
        for (Particle p : this.particles) {
            p.render();
        }
        GSB.srCam.end();
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    public int getRate() {
        return this.rate;
    }
}

