/*
 * Decompiled with CFR 0.152.
 */
package particles;

import com.badlogic.gdx.graphics.Color;
import data.GSB;
import data.TextureManager;

public class Particle {
    public float x;
    public float y;
    float vx;
    float vy;
    Color c;
    float gravity = 0.0f;
    float life = 2.0f;
    String texture = null;

    public Particle(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(Color c) {
        this.c = c;
    }

    public void setSpeed(float x, float y) {
        this.vx = x;
        this.vy = y;
    }

    public void setLife(float life) {
        this.life = life;
    }

    public void updateParticle(float delta) {
        this.life -= delta;
        this.x += this.vx * delta * 60.0f;
        this.y += this.vy * delta * 60.0f;
        this.vy += this.gravity * delta * 60.0f;
    }

    public void enableGravity(float gravity) {
        this.gravity = gravity;
    }

    public boolean dieCondition() {
        return this.life < 0.0f;
    }

    public void render() {
        if (this.texture == null) {
            GSB.srCam.setColor(this.c);
            GSB.srCam.rect(this.x, this.y, 2.0f, 2.0f);
        } else {
            GSB.sb.draw(TextureManager.get(this.texture), this.x, this.y);
        }
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }
}

