/*
 * Decompiled with CFR 0.152.
 */
package map;

import data.Coord;
import data.GSB;
import java.io.Serializable;
import java.util.ArrayList;
import map.Block;

public class Map
implements Serializable {
    private static final long serialVersionUID = 3L;
    ArrayList<Block> map = new ArrayList();
    Coord gentil;
    Coord mechant;
    public static final int GROUND = 8;
    public static final int LEFT = 2;
    public static final int RIGHT = 1;

    public void setPlayersPosition(Coord gentil, Coord mechant) {
        this.gentil = gentil;
        this.mechant = mechant;
    }

    public Coord getGentilPos() {
        return this.gentil;
    }

    public Coord getMechantPos() {
        return this.mechant;
    }

    public void addBox(Coord c) {
        this.map.add(new Block(c));
    }

    public void addBox(Coord c, int type) {
        this.map.add(new Block(c));
        this.map.get(this.map.size() - 1).setType(type);
    }

    private int getNeighbour(Block c) {
        if (c.type == 1) {
            return 8;
        }
        boolean right = false;
        boolean left = false;
        for (Block a : this.map) {
            if (a.type != c.type || a.getY() != c.getY()) continue;
            if (a.getX() == c.getX() - 1.0f) {
                left = true;
            }
            if (a.getX() != c.getX() + 1.0f) continue;
            right = true;
        }
        int flag = 8;
        if (!right || !left) {
            if (right) {
                flag = 1;
            }
            if (left) {
                flag = 2;
            }
        }
        return flag;
    }

    public void computeTypes() {
        for (Block c : this.map) {
            c.setFlag(this.getNeighbour(c));
        }
    }

    public ArrayList<Block> getBlocks() {
        return this.map;
    }

    public void render(float delta) {
        for (Block c : this.map) {
            c.render(delta);
        }
        if (GSB.srCam.isDrawing()) {
            GSB.srCam.end();
        }
        if (GSB.sb.isDrawing()) {
            GSB.sb.end();
        }
    }
}

