/*
 * Decompiled with CFR 0.152.
 */
package map;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import data.Coord;
import data.GSB;
import data.TextureManager;
import java.io.Serializable;

public class Block
implements Serializable {
    private static final long serialVersionUID = 12L;
    public Coord pos;
    int type = 0;
    int flag;
    float animationCount = 0.0f;

    public Block(int x, int y) {
        this.pos = new Coord(x, y);
    }

    public Block(Coord c) {
        this.pos = c;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getType() {
        return this.type;
    }

    public float getX() {
        return this.pos.getX();
    }

    public float getY() {
        return this.pos.getY();
    }

    public void render(float delta) {
        this.animationCount += delta;
        if (this.type == 0) {
            if (!GSB.sb.isDrawing()) {
                if (GSB.srCam.isDrawing()) {
                    GSB.srCam.end();
                }
                GSB.sb.begin();
            }
            String path = "sol.png";
            if (this.flag == 1) {
                path = "bord_g.png";
            }
            if (this.flag == 2) {
                path = "bord_d.png";
            }
            GSB.sb.draw(TextureManager.get(path), this.pos.getX() * 256.0f, this.pos.getY() * 256.0f);
        }
        if (this.type == 1) {
            int width = 210;
            int height = 210;
            if (!GSB.srCam.isDrawing()) {
                if (GSB.sb.isDrawing()) {
                    GSB.sb.end();
                }
                GSB.srCam.begin(ShapeRenderer.ShapeType.Filled);
            }
            GSB.srCam.setColor(new Color(0.5803922f, 0.0f, 0.827451f, 1.0f));
            GSB.srCam.rect(this.getX() * 256.0f + (float)((256 - width) / 2), this.getY() * 256.0f + (float)((256 - height) / 2), width / 2, height / 2, width, height, 1.0f, 1.0f, this.animationCount * 360.0f * 0.1f);
            GSB.srCam.setColor(new Color(0.4627451f, 0.0f, 0.4627451f, 1.0f));
            width = 190;
            height = 190;
            GSB.srCam.rect(this.getX() * 256.0f + (float)((256 - width) / 2), this.getY() * 256.0f + (float)((256 - height) / 2), width / 2, height / 2, width, height, 1.0f, 1.0f, -this.animationCount * 360.0f * 0.15f);
            GSB.srCam.setColor(new Color(0.25490198f, 0.0f, 0.25490198f, 1.0f));
            width = 160;
            height = 160;
            GSB.srCam.rect(this.getX() * 256.0f + (float)((256 - width) / 2), this.getY() * 256.0f + (float)((256 - height) / 2), width / 2, height / 2, width, height, 1.0f, 1.0f, this.animationCount * 360.0f * 0.05f + 27.0f);
        }
        if (this.type > 1) {
            System.out.println("WTFFFFFFFFFFFFF");
        }
    }
}

