/*
 * Decompiled with CFR 0.152.
 */
package game;

import boxs.Box;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import data.Coord;
import data.FontManager;
import data.GSB;
import data.SpriteManager;
import data.TextureManager;
import java.util.ArrayList;
import map.Block;
import particles.ParticleEmitter;
import screens.Game;
import screens.Options;
import weapons.BulletWeapon;
import weapons.MeleeWeapon;
import weapons.Pistol;
import weapons.Weapon;

public class Personnage {
    Animation sprite;
    public int id;
    boolean moving = true;
    public boolean jumping = false;
    int originX;
    int originY;
    ParticleEmitter blood = new ParticleEmitter(0, 0, 8.0f);
    float x;
    float y;
    float vy;
    private float vx;
    ArrayList<Polygon> collisions;
    boolean direction = false;
    float time;
    float count;
    int speed = 23;
    float acceleration;
    float realAcceleration = this.acceleration = 1.2f;
    float friction = 0.8f;
    int jumpspeed = 34;
    public int jumps = 2;
    private int dieY;
    int life = 100;
    Sprite ui;
    int score;
    float physicsPrecision = 1.0f;
    float gravity = 0.8f;
    float invincible = 2.0f;
    ArrayList<Block> map;
    Rectangle hitbox = new Rectangle(this.x + 23.0f, this.y + 3.0f, 55.0f, 125.0f);
    Weapon weapon;
    Personnage enemy;
    BitmapFont weaponText = null;
    float weaponNameActual = 0.0f;
    float weaponNameTime = 1.0f;
    public Game g;
    int bugCorector = 5;
    Polygon collidedPoly;
    Block collided;

    public Personnage(int id, int dieY, Game g) {
        this.g = g;
        this.dieY = dieY;
        this.id = id;
        this.collisions = new ArrayList();
        this.map = new ArrayList();
        this.blood.setTexture("blood.png");
        this.blood.setRate(8);
        this.blood.enableGravity(-0.2f);
        this.blood.setLife(20.0f);
        this.weaponText = FontManager.getInstance(50);
        this.ui = new Sprite(SpriteManager.get("personnage_ui.png"));
        if (id == 1) {
            this.ui.flip(true, false);
            this.ui.setPosition((float)Gdx.graphics.getWidth() - this.ui.getWidth(), (float)Gdx.graphics.getHeight() - this.ui.getHeight());
        } else {
            this.ui.setPosition(0.0f, (float)Gdx.graphics.getHeight() - this.ui.getHeight());
        }
        Array<TextureRegion> frames = new Array<TextureRegion>();
        int i = 1;
        while (i <= 4) {
            Texture cur = null;
            cur = id == 0 ? TextureManager.get("Gentil/gauche" + i + ".png") : TextureManager.get("Mechant/gauche" + i + ".png");
            frames.add(TextureRegion.split(cur, cur.getWidth(), cur.getHeight())[0][0]);
            ++i;
        }
        this.sprite = new Animation(0.1f, frames);
        this.sprite.setPlayMode(Animation.PlayMode.LOOP);
    }

    public void setEnnemy(Personnage ennemy) {
        this.enemy = ennemy;
    }

    public void render(float delta) {
        this.blood.render();
        if (this.jumping) {
            GSB.sb.draw(this.sprite.getKeyFrame(0.2f), this.x, this.y);
        } else if (this.moving) {
            GSB.sb.draw(this.sprite.getKeyFrame(this.time, true), this.x, this.y);
        } else {
            GSB.sb.draw(this.sprite.getKeyFrame(0.0f), this.x, this.y);
        }
        this.weapon.render(delta);
        if (this.isInvicible()) {
            Texture shield = TextureManager.get("shield.png");
            GSB.sb.draw(shield, this.x + (float)((this.sprite.getKeyFrame(0.0f).getRegionWidth() - shield.getWidth()) / 2), this.y + (float)((this.sprite.getKeyFrame(0.0f).getRegionHeight() - shield.getHeight()) / 2));
        }
        if (this.weaponNameActual > 0.0f) {
            this.weaponText.setColor(0.0f, 0.0f, 0.0f, this.weaponNameActual / this.weaponNameTime);
            this.weaponText.draw((Batch)GSB.sb, this.weapon.getName(), this.x, this.y + this.hitbox.height + 30.0f + (this.weaponNameTime - this.weaponNameActual) * 100.0f);
        }
    }

    public void renderUI() {
        GSB.hud.begin();
        this.ui.draw(GSB.hud);
        GSB.hud.end();
        if (this.id == 0) {
            GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
            GSB.srHud.setColor(1.0f, 0.0f, 0.0f, 0.7f);
            GSB.srHud.rect(this.ui.getX() + 64.0f, this.ui.getY() + 93.0f, (float)this.life * 1.5f, 10.0f);
            GSB.srHud.setColor(1.0f, 0.8156863f, 0.078431375f, 0.7f);
            if (Options.get("ammo")) {
                GSB.srHud.rect(this.ui.getX() + 64.0f, this.ui.getY() + 73.0f, (float)this.weapon.getAmmo() / (float)this.weapon.getMaxAmmo() * 150.0f, 10.0f);
            } else {
                Weapon weapon;
                if (this.weapon instanceof BulletWeapon) {
                    weapon = (BulletWeapon)this.weapon;
                    if (((BulletWeapon)weapon).getLastFire() == 0.0f) {
                        GSB.srHud.setColor(0.1f, 1.0f, 0.0f, 0.7f);
                    }
                    GSB.srHud.rect(this.ui.getX() + 64.0f, this.ui.getY() + 73.0f, (1.0f - ((BulletWeapon)weapon).getLastFire() / (float)((BulletWeapon)weapon).getFireRate()) * 150.0f, 10.0f);
                }
                if (this.weapon instanceof MeleeWeapon) {
                    weapon = (MeleeWeapon)this.weapon;
                    if (((MeleeWeapon)weapon).wait < 0.0f) {
                        GSB.srHud.setColor(0.1f, 1.0f, 0.0f, 0.7f);
                    }
                    GSB.srHud.rect(this.ui.getX() + 64.0f, this.ui.getY() + 73.0f, 2.5f * (0.4f - (((MeleeWeapon)weapon).wait > 0.0f ? ((MeleeWeapon)weapon).wait : 0.0f)) * 150.0f, 10.0f);
                }
            }
            GSB.srHud.end();
            GSB.hud.begin();
            FontManager.get(10).draw((Batch)GSB.hud, String.valueOf(this.life) + "/100", this.ui.getX() + 120.0f, this.ui.getY() + 101.0f);
            if (Options.get("ammo")) {
                FontManager.get(10).draw((Batch)GSB.hud, String.valueOf(this.weapon.getAmmo()) + "/" + this.weapon.getMaxAmmo(), this.ui.getX() + 120.0f, this.ui.getY() + 81.0f);
            }
            FontManager.get(12).draw((Batch)GSB.hud, "Arme : " + this.weapon.getName(), this.ui.getX() + 80.0f, this.ui.getY() + 60.0f);
            FontManager.get(12).draw((Batch)GSB.hud, "Score", this.ui.getX() + 10.0f, this.ui.getY() + 50.0f);
            FontManager.get(12).draw((Batch)GSB.hud, "" + this.score, this.ui.getX() + 10.0f, this.ui.getY() + 30.0f);
            GSB.hud.draw(TextureManager.get("Gentil/avatar.png"), this.ui.getX() + 5.0f, this.ui.getY() + this.ui.getHeight() - 50.0f);
            GSB.hud.end();
        } else {
            GSB.srHud.begin(ShapeRenderer.ShapeType.Filled);
            GSB.srHud.setColor(1.0f, 0.0f, 0.0f, 0.7f);
            GSB.srHud.rect(this.ui.getX() + 178.0f, this.ui.getY() + 93.0f, -((float)this.life * 1.5f), 10.0f);
            GSB.srHud.setColor(1.0f, 0.8156863f, 0.078431375f, 0.7f);
            if (Options.get("ammo")) {
                GSB.srHud.rect(this.ui.getX() + 178.0f, this.ui.getY() + 73.0f, -((float)this.weapon.getAmmo() / (float)this.weapon.getMaxAmmo()) * 150.0f, 10.0f);
            } else {
                Weapon weapon;
                if (this.weapon instanceof BulletWeapon) {
                    weapon = (BulletWeapon)this.weapon;
                    if (((BulletWeapon)weapon).getLastFire() == 0.0f) {
                        GSB.srHud.setColor(0.1f, 1.0f, 0.0f, 0.7f);
                    }
                    GSB.srHud.rect(this.ui.getX() + 178.0f, this.ui.getY() + 73.0f, -(1.0f - ((BulletWeapon)weapon).getLastFire() / (float)((BulletWeapon)weapon).getFireRate()) * 150.0f, 10.0f);
                }
                if (this.weapon instanceof MeleeWeapon) {
                    weapon = (MeleeWeapon)this.weapon;
                    if (((MeleeWeapon)weapon).wait < 0.0f) {
                        GSB.srHud.setColor(0.1f, 1.0f, 0.0f, 0.7f);
                    }
                    GSB.srHud.rect(this.ui.getX() + 178.0f, this.ui.getY() + 73.0f, -2.5f * (0.4f - (((MeleeWeapon)weapon).wait > 0.0f ? ((MeleeWeapon)weapon).wait : 0.0f)) * 150.0f, 10.0f);
                }
            }
            GSB.srHud.end();
            GSB.hud.begin();
            FontManager.get(10).draw((Batch)GSB.hud, String.valueOf(this.life) + "/100", this.ui.getX() + 85.0f, this.ui.getY() + 101.0f);
            if (Options.get("ammo")) {
                FontManager.get(10).draw((Batch)GSB.hud, String.valueOf(this.weapon.getAmmo()) + "/" + this.weapon.getMaxAmmo(), this.ui.getX() + 85.0f, this.ui.getY() + 81.0f);
            }
            FontManager.get(12).draw((Batch)GSB.hud, "Arme : " + this.weapon.getName(), this.ui.getX() + 64.0f, this.ui.getY() + 60.0f);
            FontManager.get(12).draw((Batch)GSB.hud, "Score", this.ui.getX() + 190.0f, this.ui.getY() + 50.0f);
            FontManager.get(12).draw((Batch)GSB.hud, "" + this.score, this.ui.getX() + 210.0f, this.ui.getY() + 30.0f);
            GSB.hud.draw(TextureManager.get("Mechant/avatar.png"), this.ui.getX() + 192.0f, this.ui.getY() + this.ui.getHeight() - 50.0f);
            GSB.hud.end();
        }
    }

    public void setWeapon(Weapon newweapon) {
        this.weaponNameActual = this.weaponNameTime;
        newweapon.setOwner(this);
        this.weapon = newweapon;
    }

    public boolean isDead() {
        return this.y < (float)this.getDieY() || this.life <= 0;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setOrigin(float f, float g) {
        this.originX = (int)f;
        this.originY = (int)g;
        this.setLocation(this.originX, this.originY);
    }

    public void testBoxs(ArrayList<Box> other) {
        int i = 0;
        while (i < other.size()) {
            Box b = other.get(i);
            if (this.hitbox.overlaps(b.getBoundingBox())) {
                b.action(this);
                other.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void update(float delta) {
        if (this.invincible > 0.0f) {
            this.invincible -= delta;
        }
        if (this.weaponNameActual > 0.0f) {
            this.weaponNameActual -= delta;
        }
        if (this.bugCorector-- > 0) {
            delta = 0.016666668f;
        }
        if (this.weapon instanceof BulletWeapon && ((BulletWeapon)this.weapon).getAmmo() <= 0 && ((BulletWeapon)this.weapon).getName() != "Pistol") {
            this.setWeapon(new Pistol());
        }
        this.blood.update(delta * 2.0f);
        this.time += delta;
        this.x += this.vx * delta * 60.0f;
        if (this.collision()) {
            if (this.collided.getType() == 1) {
                this.collided = null;
                this.respawn();
            }
            this.x -= this.vx * delta * 60.0f;
            this.vx = this.onGround() ? -this.vx / 2.0f : 0.0f;
            this.moving = false;
        }
        if (this.onGround()) {
            if (this.moving) {
                this.vx += (this.vx < 0.0f ? this.friction : -this.friction) * delta * 60.0f;
                if (Math.abs(this.vx) < delta * 60.0f * this.friction) {
                    this.vx = 0.0f;
                }
            }
            this.realAcceleration = this.acceleration * 2.0f;
            this.jumps = 2;
        } else {
            this.realAcceleration = this.acceleration;
            if (!this.jumping) {
                this.vy = 0.0f;
                this.jumping = true;
            }
        }
        this.moving = this.vx != 0.0f;
        this.count += delta;
        if (this.count > 5.0f) {
            ++this.life;
            this.count -= 5.0f;
        }
        if (this.life > 100) {
            this.life = 100;
        }
        if (this.collided != null && this.collided.getType() == 1) {
            this.collided = null;
            this.respawn();
        }
        if (this.jumping) {
            this.setVy(this.vy - this.gravity * delta * 60.0f);
            this.y += this.vy * delta * 60.0f;
            if (this.collision()) {
                if (this.vy > 0.0f) {
                    while (this.collision()) {
                        this.y -= this.physicsPrecision;
                    }
                }
                if (this.vy < 0.0f) {
                    this.jumping = false;
                    this.jumps = 2;
                    float max = -1000000.0f;
                    int i = 1;
                    while (i < this.collidedPoly.getTransformedVertices().length) {
                        if (this.collidedPoly.getTransformedVertices()[i] > max) {
                            max = this.collidedPoly.getTransformedVertices()[i];
                        }
                        i += 2;
                    }
                    this.y = max - 2.3f;
                }
                this.setVy(0.0f);
            } else if (this.jumps > 0) {
                this.jumps = 1;
            }
        }
        if (this.isDead()) {
            this.respawn();
        }
        this.blood.setX((int)(this.hitbox.x + this.hitbox.width / 2.0f));
        this.blood.setY((int)(this.hitbox.y + this.hitbox.height / 2.0f));
        this.weapon.update(delta);
    }

    public boolean onGround() {
        this.hitbox.setPosition(this.x + 20.0f, this.y - 2.0f);
        int i = 0;
        while (i < this.collisions.size()) {
            if (this.isCollision(this.collisions.get(i), this.hitbox)) {
                this.collidedPoly = this.collisions.get(i);
                this.collided = this.map.get(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addCollision(Block c) {
        int type = c.getFlag();
        float[] vertices = null;
        if (c.getType() == 0) {
            if (type == 8) {
                vertices = new float[]{0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 210.0f, 0.0f, 210.0f};
            }
            if (type == 1) {
                vertices = new float[]{10.0f, 210.0f, 10.0f, 180.0f, 190.0f, 0.0f, 256.0f, 0.0f, 256.0f, 210.0f};
            }
            if (type == 2) {
                vertices = new float[]{0.0f, 0.0f, 70.0f, 0.0f, 240.0f, 180.0f, 240.0f, 210.0f, 0.0f, 210.0f};
            }
        } else if (c.getType() == 1) {
            vertices = new float[]{0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 256.0f, 0.0f, 256.0f};
        }
        this.collisions.add(new Polygon(vertices));
        this.map.add(c);
        this.collisions.get(this.collisions.size() - 1).setPosition(c.getX() * 256.0f, c.getY() * 256.0f);
        while (this.collision()) {
            this.y += this.physicsPrecision;
        }
    }

    public int getLife() {
        return this.life;
    }

    public boolean isCollision(Polygon p, Rectangle r) {
        Polygon rPoly = new Polygon(new float[]{0.0f, 0.0f, r.width, 0.0f, r.width, r.height, 0.0f, r.height});
        rPoly.setPosition(r.x, r.y);
        return Intersector.overlapConvexPolygons(rPoly, p);
    }

    public boolean collision() {
        this.hitbox.setPosition(this.x + 20.0f, this.y + 3.0f);
        int i = 0;
        while (i < this.collisions.size()) {
            if (this.isCollision(this.collisions.get(i), this.hitbox)) {
                this.collidedPoly = this.collisions.get(i);
                this.collided = this.map.get(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testWeapon(Personnage enemy, float delta) {
        enemy.getWeapon().testHit(this, delta);
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }

    public Rectangle getVxHitbox() {
        Rectangle todo = new Rectangle(this.hitbox);
        if (this.vx < 0.0f) {
            todo.x -= this.vx;
        }
        todo.width += Math.abs(this.vx);
        return todo;
    }

    public Polygon getPolygonHitbox() {
        Rectangle old = new Rectangle(this.hitbox);
        if (this.vx < 0.0f) {
            this.hitbox.x -= this.vx;
        }
        this.hitbox.width += Math.abs(this.vx);
        Polygon p = new Polygon(new float[]{0.0f, 0.0f, this.hitbox.width, 0.0f, this.hitbox.width, this.hitbox.height, 0.0f, this.hitbox.height});
        p.setPosition(this.hitbox.x, this.hitbox.y);
        this.hitbox = old;
        return p;
    }

    public void move(boolean direction, float delta) {
        this.moving = true;
        if (this.direction != direction) {
            TextureRegion[] textureRegionArray = this.sprite.getKeyFrames();
            int n = textureRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextureRegion a = textureRegionArray[n2];
                a.flip(true, false);
                ++n2;
            }
        }
        this.direction = direction;
        if (direction && this.vx < (float)this.speed) {
            this.vx += this.realAcceleration * delta * 60.0f;
        }
        if (!direction && this.vx > (float)(-this.speed)) {
            this.vx -= this.realAcceleration * delta * 60.0f;
        }
    }

    public void fire() {
        Weapon casted;
        if (this.weapon instanceof BulletWeapon && ((BulletWeapon)(casted = (BulletWeapon)this.weapon)).canShoot()) {
            ((BulletWeapon)casted).fire();
        }
        if (this.weapon instanceof MeleeWeapon && !((MeleeWeapon)(casted = (MeleeWeapon)this.weapon)).isSwinging()) {
            ((MeleeWeapon)casted).swing();
        }
    }

    public void renderCollision() {
        GSB.srCam.begin(ShapeRenderer.ShapeType.Line);
        GSB.srCam.setColor(Color.RED);
        for (Polygon p : this.collisions) {
            float[] vertices = p.getVertices();
            int i = 0;
            while (i < vertices.length) {
                GSB.srCam.line(p.getX() + vertices[i], p.getY() + vertices[i + 1], p.getX() + vertices[(i + 2) % vertices.length], p.getY() + vertices[(i + 3) % vertices.length]);
                i += 2;
            }
        }
        GSB.srCam.rect(this.hitbox.getX(), this.hitbox.getY(), this.hitbox.getWidth(), this.hitbox.getHeight());
        GSB.srCam.end();
    }

    public void jump() {
        if (Game.debug) {
            this.setVy(this.jumpspeed);
            this.jumping = true;
            return;
        }
        if (this.jumps > 0) {
            --this.jumps;
            this.jumping = true;
            this.setVy(this.jumpspeed);
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void respawn() {
        this.x = this.originX;
        this.y = this.originY;
        this.invincible = 1.0f;
        ++this.enemy.score;
        this.life = 100;
        this.jumping = false;
        this.moving = false;
        this.vy = 0.0f;
        this.vx = 0.0f;
        this.setWeapon(new Pistol());
        this.blood.setRate(100);
        this.blood.startEmitting();
        this.blood.update(0.016666668f);
        this.blood.stopEmitting();
        this.blood.setRate(8);
        while (this.collision()) {
            this.y += this.physicsPrecision;
        }
    }

    public void setOrigin(Coord pos) {
        this.setOrigin(pos.getX(), pos.getY());
    }

    public void addLife(int i) {
        if (i <= 0) {
            this.blood.startEmitting(0.1f);
        }
        this.life += i;
        if (this.life > 100) {
            this.life = 100;
        }
    }

    public ArrayList<Polygon> getCollisions() {
        return this.collisions;
    }

    public float getVx() {
        return this.vx;
    }

    public void setVx(float vx) {
        this.vx = vx;
    }

    public float getVy() {
        return this.vy;
    }

    public void setVy(float vy) {
        this.vy = vy;
    }

    public int getDieY() {
        return this.dieY;
    }

    public boolean isInvicible() {
        return this.invincible > 0.0f;
    }
}

