/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Polygon;
import data.GSB;
import data.SpriteManager;
import entities.Entity;
import game.Personnage;

public class EntityTest
extends Entity {
    public EntityTest() {
        this.id = 0;
        this.image = new Sprite(SpriteManager.get("pwned.png"));
        this.hitbox = this.image.getBoundingRectangle();
        this.vy = -200.0f;
    }

    @Override
    public void onPlayerHit(Personnage hit) {
        hit.addLife(0);
        hit.setVx(-10.0f);
    }

    @Override
    public void onPolygonCollision(Polygon p) {
        this.image.setFlip(true, true);
        this.vy = 0.0f;
    }

    @Override
    public void render() {
        this.image.draw(GSB.sb);
    }

    @Override
    public void update(float delta) {
        this.y += this.vy * delta;
        this.image.setPosition(this.getX(), this.y);
        this.hitbox.setPosition(this.getX(), this.y);
        this.image.setFlip(false, false);
    }
}

