/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import data.GSB;
import data.SpriteManager;
import entities.Entity;
import game.Personnage;
import screens.Game;
import screens.Options;

public class Bullet
extends Entity {
    int dmg;
    float angle;
    float velocityScale;
    int ownerId;
    float lastDelta = 0.0f;

    public Bullet(float x, float y, float vx, float vy, int dmg, float velocityScale, int ownerId) {
        this.id = 2;
        this.ownerId = ownerId;
        this.dmg = dmg;
        this.velocityScale = velocityScale;
        this.setX(x);
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.image = SpriteManager.get("Armes/bullet.png");
        this.image.setOrigin(this.image.getWidth() / 2.0f, this.image.getHeight() / 2.0f);
        this.angle = this.getAngle(vx, vy);
    }

    @Override
    public void onPlayerHit(Personnage hit) {
        if (hit.id != this.ownerId) {
            float lifemultiplier = 1.0f + 4.0f * (100.0f - (float)hit.getLife()) / 100.0f;
            if (hit.isInvicible() || Game.invincible) {
                hit.addLife(0);
            } else {
                hit.addLife(-this.dmg);
                if (Options.get("brawl")) {
                    hit.setVx(hit.getVx() / 2.0f + this.vx * this.velocityScale * lifemultiplier);
                }
            }
            this.delete = true;
        }
    }

    private float getAngle(float vx, float vy) {
        float angle = (float)Math.toDegrees(Math.acos((double)vx / Math.sqrt(vx * vx + vy * vy)));
        if (vy < 0.0f) {
            angle = -angle;
        }
        return angle;
    }

    @Override
    public void update(float delta) {
        this.setX(this.getX() + this.vx * (delta * 60.0f));
        this.y += this.vy * (delta * 60.0f);
        this.lastDelta = delta;
    }

    public Vector2[] getCollision(float delta) {
        Vector2[] collision;
        collision = new Vector2[]{this.vx > 0.0f ? new Vector2(this.getX() + this.image.getWidth() - 30.0f, this.y + this.image.getHeight() / 2.0f) : new Vector2(this.getX() + 30.0f, this.y + this.image.getHeight() / 2.0f), new Vector2(collision[0].x + this.vx * delta * 60.0f, collision[0].y + this.vy * delta * 60.0f)};
        return collision;
    }

    public void inverteVx() {
        this.vx = -this.vx;
        this.angle = this.getAngle(this.vx, this.vy);
    }

    @Override
    public void render() {
        this.image.setRotation(this.angle);
        this.image.setPosition(this.getX(), this.y);
        this.image.draw(GSB.sb);
    }

    @Override
    public void onPolygonCollision(Polygon p) {
        this.delete = true;
    }

    @Override
    public boolean polygonTest(Polygon p) {
        if (this.vx < 0.0f) {
            return p.contains(this.x, this.y);
        }
        return p.contains(this.x + this.image.getWidth(), this.y);
    }

    @Override
    public boolean playerTest(Personnage p) {
        Vector2[] pos = this.getCollision(this.lastDelta);
        return this.isCollision(pos, p.getVxHitbox()) || p.getVxHitbox().contains(pos[0]);
    }

    public boolean isCollision(Vector2[] seg, Rectangle r) {
        Vector2 b;
        Vector2 a = new Vector2(r.getX(), r.getY());
        if (Intersector.intersectSegments(seg[0], seg[1], a, b = new Vector2(r.getX() + r.getWidth(), r.getY()), null)) {
            return true;
        }
        b.x = r.getX();
        b.y = r.getY() + r.getHeight();
        if (Intersector.intersectSegments(seg[0], seg[1], a, b, null)) {
            return true;
        }
        a.x = r.getX() + r.getWidth();
        a.y = r.getY() + r.getHeight();
        if (Intersector.intersectSegments(seg[0], seg[1], a, b, null)) {
            return true;
        }
        b.x = r.getX() + r.getWidth();
        b.y = r.getY();
        return Intersector.intersectSegments(seg[0], seg[1], a, b, null);
    }
}

