/*
 * Decompiled with CFR 0.152.
 */
package data;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.util.HashMap;
import java.util.Map;

public class TextureManager {
    static Map<String, Texture> textures = new HashMap<String, Texture>();
    static Map<String, Pixmap> pixs = new HashMap<String, Pixmap>();

    public static Texture get(String filename) {
        if (textures.get(filename) == null) {
            try {
                textures.put(filename, new Texture(Gdx.files.internal(filename)));
                System.out.println("[LOAD][TEXTURE] loaded : " + filename);
            }
            catch (Exception e) {
                System.out.println("Couldn't load texture : " + filename);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return textures.get(filename);
    }

    public static Pixmap getPixmap(String filename) {
        if (pixs.get(filename) == null) {
            try {
                pixs.put(filename, new Pixmap(Gdx.files.internal(filename)));
            }
            catch (Exception e) {
                System.out.println("Couldn't find pixmap : " + filename);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return pixs.get(filename);
    }
}

