/*
 * Decompiled with CFR 0.152.
 */
package AI;

import data.Coord;
import data.GSB;
import java.util.ArrayList;
import java.util.Collections;

public class Path {
    ArrayList<Coord> path = new ArrayList();

    public void addCoord(Coord coord) {
        this.path.add(coord);
    }

    public ArrayList<Coord> getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.path.isEmpty();
    }

    public void clear() {
        this.path.clear();
    }

    public Coord getLastCoord() {
        return this.path.get(this.path.size() - 1);
    }

    public Coord getCoord(int i) {
        if (i == -1) {
            return null;
        }
        if (this.path.size() > i) {
            return this.path.get(i);
        }
        return this.getCoord(i - 1);
    }

    public Coord getFirstCoord() {
        if (this.path.size() > 0) {
            return this.path.get(0);
        }
        return null;
    }

    public Coord getSecondCoord() {
        if (this.path.size() > 1) {
            return this.path.get(1);
        }
        return this.getFirstCoord();
    }

    public String toString() {
        String s = "";
        for (Coord c : this.path) {
            s = String.valueOf(s) + c.toString();
        }
        return s;
    }

    public void renderPath() {
        float count = 0.0f;
        for (Coord c : this.path) {
            float f = count;
            count = f + 1.0f;
            GSB.srCam.setColor(0.0f, f / (float)this.path.size(), 0.0f, 1.0f);
            GSB.srCam.circle(c.X() * 256, c.Y() * 256, 40.0f);
        }
    }

    public void reverse() {
        Collections.reverse(this.path);
    }
}

