/*
 * Decompiled with CFR 0.152.
 */
package personnage;

import Multi.Client;
import Multi.Multi;
import Multi.PacketPersoClient;
import Multi.PacketPersoServer;
import Multi.Serveur;
import java.awt.Font;
import java.util.ArrayList;
import main.Jeu;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.geom.Rectangle;
import personnage.Arme;
import personnage.Balles;
import personnage.Zombie;
import world.Combat;
import world.SaveAndLoadMap;

public class Personnage {
    public int x;
    public int y = 300;
    int vy = 0;
    public int score = 0;
    ArrayList<Image> spritegauche;
    ArrayList<Image> spritedroite;
    ArrayList<Rectangle> boxs;
    TrueTypeFont font;
    public Balles balles;
    Sound gunfire;
    public int id = 0;
    int right = 0;
    int left = 0;
    public int counterRight = 0;
    public int counterLeft = 0;
    public int direction;
    public int vie = 100;
    public int armure = 0;
    int timerRegen;
    public int munitions = 50;
    public int fireSpeed = 4;
    public int timeSinceLastFire = 0;
    boolean jumping = false;
    public Arme arme;

    public Personnage(int id) throws SlickException {
        this.x = id == 0 ? 100 : 675;
        this.id = id;
        this.direction = id == 0 ? 1 : 0;
        this.arme = new Arme();
        this.spritegauche = new ArrayList();
        this.spritedroite = new ArrayList();
        this.boxs = new ArrayList();
        this.boxs = SaveAndLoadMap.getBoxs();
        this.balles = new Balles();
        this.font = new TrueTypeFont(new Font("Calibri", 0, 10), true);
        this.gunfire = new Sound("res/sons/firegun.ogg");
        if (id == 0) {
            this.spritegauche.add(new Image("res/Personnages/Gentil/gauche1.png"));
            this.spritegauche.add(new Image("res/Personnages/Gentil/gauche2.png"));
            this.spritegauche.add(new Image("res/Personnages/Gentil/gauche3.png"));
            this.spritegauche.add(new Image("res/Personnages/Gentil/gauche4.png"));
            this.spritedroite.add(new Image("res/Personnages/Gentil/droite1.png"));
            this.spritedroite.add(new Image("res/Personnages/Gentil/droite2.png"));
            this.spritedroite.add(new Image("res/Personnages/Gentil/droite3.png"));
            this.spritedroite.add(new Image("res/Personnages/Gentil/droite4.png"));
        } else {
            this.spritegauche.add(new Image("res/Personnages/Mechant/gauche1.png"));
            this.spritegauche.add(new Image("res/Personnages/Mechant/gauche2.png"));
            this.spritegauche.add(new Image("res/Personnages/Mechant/gauche3.png"));
            this.spritegauche.add(new Image("res/Personnages/Mechant/gauche4.png"));
            this.spritedroite.add(new Image("res/Personnages/Mechant/droite1.png"));
            this.spritedroite.add(new Image("res/Personnages/Mechant/droite2.png"));
            this.spritedroite.add(new Image("res/Personnages/Mechant/droite3.png"));
            this.spritedroite.add(new Image("res/Personnages/Mechant/droite4.png"));
        }
    }

    public void draw(Graphics g) {
        this.arme.draw(g, this.x, this.y, this.direction);
        if (this.direction == 1) {
            g.drawImage(this.spritedroite.get(this.right), this.x, this.y + 1);
        } else {
            g.drawImage(this.spritegauche.get(this.left), this.x, this.y + 1);
        }
        g.setColor(Color.red);
        if (Jeu.debug) {
            g.drawRect(this.x, this.y, 22.0f, 32.0f);
        }
        this.arme.draw(g, this.x, this.y, this.direction);
        if (this.vie >= 20) {
            g.setColor(Color.orange);
        }
        if (this.vie >= 40) {
            g.setColor(new Color(65298));
        }
        g.fillRect(this.x - 5, this.y - 8, 30 * this.vie / 100, 3.0f);
        g.setColor(Color.yellow);
        g.fillRect(this.x - 5, this.y - 5, 30 * this.munitions / 50, 3.0f);
        g.setColor(new Color(5883631));
        g.fillRect(this.x - 5, this.y - 8, 30 * this.armure / 100, 3.0f);
        g.setColor(new Color(16735222));
        g.fillRect(this.x - 5, this.y - 12, 30 * this.score / 10, 3.0f);
        this.balles.draw(g);
    }

    public void update() {
        this.y += this.vy++;
        if (this.intersect()) {
            if (this.vy > 0) {
                this.y = this.y / 32 * 32 - 1;
                this.jumping = false;
            }
            if (this.vy < 0) {
                this.y = (this.y / 32 + 1) * 32 - 1;
            }
            this.vy = 0;
        }
        this.balles.update();
        this.balles.test(this.boxs);
        if (this.timerRegen >= 30) {
            ++this.vie;
            this.timerRegen = 0;
        } else if (this.vie < 100) {
            ++this.timerRegen;
        }
        if (Jeu.state == "jeu" || Jeu.state == "zombie") {
            Combat.boxs.check(this);
        } else if (Multi.imserver) {
            Serveur.boxs.check(this);
        } else {
            Client.boxs.check(this);
        }
    }

    public void testBalle(Balles b) {
        b.test(this);
    }

    public void testZombie(ArrayList<Zombie> zomb) {
        Rectangle me = new Rectangle(this.x, this.y, 22.0f, 32.0f);
        if (!Jeu.debug) {
            int i = 0;
            while (i < zomb.size()) {
                Rectangle zombie = new Rectangle(zomb.get((int)i).x, zomb.get((int)i).y, 22.0f, 32.0f);
                if (me.intersects(zombie)) {
                    if (this.armure > 0) {
                        this.armure = this.armure - 50 < 0 ? 0 : this.armure - 50;
                    } else {
                        this.vie -= 10;
                    }
                    zomb.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    public boolean testMort() {
        if (this.y > 640) {
            return true;
        }
        return this.vie <= 0;
    }

    public void tirer() throws SlickException {
        if (this.munitions > 0) {
            this.balles.add(this.x + 7, this.y + 22, this.id, this.direction);
            --this.munitions;
            this.gunfire.play();
        }
    }

    public void move(int direction) {
        if (direction == 1) {
            this.x += 5;
            if (this.intersect()) {
                this.x -= 5;
            }
            this.counterRight += 2;
            this.direction = 1;
        } else {
            this.x -= 5;
            if (this.intersect()) {
                this.x += 5;
            }
            this.counterLeft += 2;
            this.direction = 0;
        }
        if (this.counterRight > 15) {
            this.right = this.right != 3 ? ++this.right : 0;
            this.counterRight = 0;
        }
        if (this.counterLeft > 15) {
            this.left = this.left != 3 ? ++this.left : 0;
            this.counterLeft = 0;
        }
    }

    public void jump() {
        if (!this.jumping || Jeu.debug) {
            this.vy = -14;
            this.jumping = true;
        }
    }

    private boolean intersect() {
        Rectangle rect = new Rectangle(this.x + 3, this.y + 3, 17.0f, 29.0f);
        int i = 0;
        while (i < this.boxs.size()) {
            if (this.boxs.get(i).intersects(rect)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resetAll() throws SlickException {
        this.x = this.id == 0 ? 100 : 670;
        this.y = 300;
        this.vy = 0;
        this.direction = this.id == 0 ? 1 : 0;
        this.vie = 100;
        this.right = 0;
        this.left = 0;
        this.counterRight = 0;
        this.counterLeft = 0;
        this.jumping = false;
        this.munitions = 50;
        this.arme = new Arme();
        this.timeSinceLastFire = 0;
        this.fireSpeed = 4;
        this.armure = 0;
    }

    public void set(PacketPersoServer pack) throws SlickException {
        this.x = pack.x;
        this.y = pack.y;
        this.vie = pack.vie;
        this.armure = pack.armure;
        this.direction = pack.direction ? 1 : 0;
        this.munitions = pack.munitions;
        this.counterRight = pack.counterRight;
        this.counterLeft = pack.counterLeft;
        this.score = pack.score;
        if (pack.tir) {
            this.tirer();
        }
    }

    public void set(PacketPersoClient pack) throws SlickException {
        this.x = pack.x;
        this.y = pack.y;
        this.direction = pack.direction ? 1 : 0;
        this.counterRight = pack.counterRight;
        this.counterLeft = pack.counterLeft;
        if (pack.fire) {
            this.tirer();
        }
    }
}

