package world;

import java.util.ArrayList;

import main.Jeu;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;

import personnage.Personnage;
import personnage.Zombie;
import boxs.WorldBoxs;

public class ZombieMod 
{
	Personnage gentil;
	public static WorldBoxs boxs;
	public static int[][] map;
	ArrayList<Zombie> zombieArray;
	int counterToNext = 60;
	Image fond;
	public void init() throws SlickException
	{
		fond = new Image("res/monde/fond.png");
		gentil = new Personnage(0);
		map = SaveAndLoadMap.Load();
		boxs = new WorldBoxs();
		zombieArray = new ArrayList<Zombie>();
	}
	public boolean update(Input in) throws SlickException
	{
		 counterToNext--;
		 if(counterToNext == 0)
		 {	
			 zombieArray.add(new Zombie());
			 counterToNext = 60;
		 }
		 if(Jeu.debug && in.isMousePressed(0))
			 zombieArray.add(new Zombie(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()));
			 
		 if(in.isKeyDown(Input.KEY_F))
			 gentil.move(1);
		 if(in.isKeyDown(Input.KEY_S))
			 gentil.move(0);
		 if(in.isKeyPressed(Input.KEY_E))
			 gentil.jump();
		 if(gentil.fireSpeed == 4)
		 {
			 if(in.isKeyPressed(Input.KEY_SPACE) && gentil.timeSinceLastFire >= 4)
			 {
				 gentil.tirer();
			 }
		 }
		 else if(in.isKeyDown(Input.KEY_SPACE))
		 {
			if(gentil.timeSinceLastFire >= gentil.fireSpeed)
			{
				gentil.tirer();
				gentil.timeSinceLastFire = 0;
			}
		 }
		 gentil.timeSinceLastFire++;	 
		 
//		 gentil.testBalle(mechant.balles);
		 
		 gentil.update();
		 boxs.check(gentil);
		 gentil.testZombie(zombieArray);
//		 if(mechant.testMort())
//		 {
//			 mechant.resetAll();
//			 gentil.score++;
//		 }
//		 if(gentil.testMort())
//		 {
//			 gentil.resetAll();
//			 mechant.score++;
//		 }
//		 if(mechant.score >= 10 || gentil.score >= 10)
//		 {
//			 return true;
//		 }
		 if(gentil.testMort())
		 {
			 return true;
		 }
		 boxs.update();
		 for(int i = 0 ; i < zombieArray.size() ; i++)
		 {
			 zombieArray.get(i).update();
			 zombieArray.get(i).testBalle(gentil.balles);
			 if(zombieArray.get(i).testMort())
			 {
				 zombieArray.remove(i);
				 i--;
			 }
		 }
		 return false;
	}
	public void draw(Graphics g)
	{
		g.drawImage(fond, 0, 0);
		DrawMap.draw(g);
		gentil.draw(g);
		boxs.draw(g);
		for(int i = 0 ; i < zombieArray.size() ; i++)
		{
			zombieArray.get(i).draw(g);
		}
		
		if(Jeu.debug)
		{
			g.drawRect(Jeu.zomb.getPerso().x-100+10, Jeu.zomb.getPerso().y - 100 + 15, 200, 200);
		}
	}
	public Personnage getPerso()
	{
		return gentil;
	}
}
