package world;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;


public class Editeur
{
	int[][] map;
	int selection = 0;
	int curmousex = 0, curmousey = 0;
	PetitBouton Sauver, Sortir;
	Image fond;
	public Editeur() throws SlickException
	{
		map = SaveAndLoadMap.Load();
		Sauver = new PetitBouton("Sauver", 200, 580);
		Sortir = new PetitBouton("Sortir", 500, 580);
		fond = new Image("res/monde/fond.png");
	}
	public void render(Graphics g) throws SlickException
	{
		g.drawImage(fond, 0, 0);
		DrawMap.draw(g, map);
		if(selection != 0)
			g.drawImage(DrawMap.getSprites().get(selection), curmousex, curmousey);
		g.drawImage(new Image("res/Personnages/Gentil/droite2.png"), 100, 300);
		g.drawImage(new Image("res/Personnages/Mechant/gauche2.png"), 675, 300);
		Sauver.draw(g);
		Sortir.draw(g);
	}
	public boolean update(Input in)
	{
		int wheel = Mouse.getDWheel();
		if(wheel > 0)
			selection += (selection+1>6)?-5:1;
		if(wheel < 0)
			selection -= (selection-1<1)?-5:1;
		if(in.isMouseButtonDown(0))
			map[Math.min(19,curmousey/32)][curmousex/32] = selection;
		if(in.isMouseButtonDown(Input.MOUSE_RIGHT_BUTTON))
			map[Math.min(19,curmousey/32)][curmousex/32] = 0;
		curmousex = in.getAbsoluteMouseX();
		curmousey = in.getAbsoluteMouseY();
		
		if(Sauver.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()) && in.isMouseButtonDown(0))
			SaveAndLoadMap.save(map);
		if(Sortir.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()) && in.isMouseButtonDown(0))
			return true;
		if(in.isKeyPressed(Input.KEY_V))
		{
			for(int i = 0 ; i < 20 ; i++)
			{
				for(int j = 0 ; j < 25 ; j++)
					map[i][j] = 0;
			}
		}
		if(in.isKeyPressed(Input.KEY_R))
		{
			for(int i = 0 ; i < 20 ; i++)
			{
				for(int j = 0 ; j < 25 ; j++)
					map[i][j] = 4;
			}
		}
		return false;
	}
}
