package world;
import java.util.ArrayList;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;


public class DrawMap
{
	static ArrayList<Image> sprites = new ArrayList<Image>();

	public DrawMap() throws SlickException
	{
		int numbersprite = 6;
		sprites.add(null);
		for(int i = 1 ; i <= numbersprite ; i++)
		{
			sprites.add(new Image("res/Monde/sprite"+i+".png"));
		}
	}
	
	public static void draw(Graphics g)
	{
		for(int i = 0; i<20;i++)
			for(int j=0;j<25;j++)
			{
				if(Combat.map[i][j] != 0)
					g.drawImage(sprites.get(Combat.map[i][j]), j*32, i*32);
			}
	}
	
	public static void draw(Graphics g, int[][] map)
	{
		for(int i = 0; i<20;i++)
			for(int j=0;j<25;j++)
			{
				if(map[i][j] != 0)
					g.drawImage(sprites.get(map[i][j]), j*32, i*32);
			}
	}

	public static ArrayList<Image> getSprites()
	{
		return sprites;
	}
	
}
