package world;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;

import personnage.Personnage;
import boxs.WorldBoxs;

public class Combat
{

	Personnage gentil;
	public Personnage mechant;
	public static WorldBoxs boxs;
	public static int[][] map;
	Image fond;
	public void init() throws SlickException
	{
		gentil = new Personnage(0);
		mechant = new Personnage(1);
		map = SaveAndLoadMap.Load();
		boxs = new WorldBoxs();
		fond = new Image("res/monde/fond.png");
	}
	public boolean update(Input in) throws SlickException
	{
		
		
		if(in.isKeyDown(Input.KEY_RIGHT))
			 mechant.move(1);
		 if(in.isKeyDown(Input.KEY_LEFT))
			 mechant.move(0);
		 if(in.isKeyPressed(Input.KEY_UP))
			 mechant.jump();
		 if(mechant.fireSpeed == 4)
		 {
			 if(in.isKeyPressed(Input.KEY_ENTER) && mechant.timeSinceLastFire >= 4)
			 {
				 mechant.tirer();
			 }
		 }
		 else if(in.isKeyDown(Input.KEY_ENTER))
		 {
			if(mechant.timeSinceLastFire >= mechant.fireSpeed)
			{
				mechant.tirer();
				mechant.timeSinceLastFire = 0;
			}
		 }
		 mechant.timeSinceLastFire++;
		 if(in.isKeyDown(Input.KEY_F))
			 gentil.move(1);
		 if(in.isKeyDown(Input.KEY_S))
			 gentil.move(0);
		 if(in.isKeyPressed(Input.KEY_E))
			 gentil.jump();
		 if(gentil.fireSpeed == 4)
		 {
			 if(in.isKeyPressed(Input.KEY_SPACE) && gentil.timeSinceLastFire >= 4)
			 {
				 gentil.tirer();
			 }
		 }
		 else if(in.isKeyDown(Input.KEY_SPACE))
		 {
			if(gentil.timeSinceLastFire >= gentil.fireSpeed)
			{
				gentil.tirer();
				gentil.timeSinceLastFire = 0;
			}
		 }
		 gentil.timeSinceLastFire++;	 
		 
		 gentil.testBalle(mechant.balles);
		 mechant.testBalle(gentil.balles);
		 
		 mechant.update();
		 gentil.update();
		 
		 if(mechant.testMort())
		 {
			 mechant.resetAll();
			 gentil.score++;
		 }
		 if(gentil.testMort())
		 {
			 gentil.resetAll();
			 mechant.score++;
		 }
		 if(mechant.score >= 10 || gentil.score >= 10)
		 {
			 return true;
		 }
		 boxs.update();
		 return false;
	}
	public void draw(Graphics g)
	{
		g.drawImage(fond, 0, 0);
		DrawMap.draw(g);
		gentil.draw(g);
		mechant.draw(g);
		boxs.draw(g);
	}
}
