package personnage;

import java.awt.Font;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

import main.Jeu;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.geom.Rectangle;

import world.Combat;
import world.SaveAndLoadMap;
import Multi.Client;
import Multi.PacketPersoClient;
import Multi.PacketPersoServer;
import Multi.Serveur;

public class Personnage{
	/**
	 * 
	 */
	public int x, y = 300;
	int vy = 0;
	public int score = 0;
	
	ArrayList<Image> spritegauche;
	ArrayList<Image> spritedroite;
	ArrayList <Rectangle> boxs;
	TrueTypeFont font;
	public Balles balles;
	Sound gunfire;
	
	public int id = 0;
	
	int right = 0, left = 0;
	public int counterRight = 0, counterLeft = 0;
	public int direction;
	public int vie = 100, armure = 0;
	int timerRegen;
	public int munitions = 50, fireSpeed = 0, timeSinceLastFire = 0;
	
	boolean jumping = false;

	public Arme arme;
	
	
	public Personnage(int id) throws SlickException
	{
		this.x = (id == 0)?100:675;
		this.id = id;
		direction = (id == 0)?1:0;
		arme = new Mitraillette();
		spritegauche = new ArrayList<Image>();
		spritedroite = new ArrayList<Image>();
		boxs = new ArrayList <Rectangle>();
		boxs = SaveAndLoadMap.getBoxs();
		balles = new Balles();
		font = new TrueTypeFont(new Font("Calibri",0,10),true);
		gunfire = new Sound("res/sons/firegun.ogg");
		if(id == 0)
		{
			spritegauche.add(new Image("res/Personnages/Gentil/gauche1.png"));
			spritegauche.add(new Image("res/Personnages/Gentil/gauche2.png"));
			spritegauche.add(new Image("res/Personnages/Gentil/gauche3.png"));
			spritegauche.add(new Image("res/Personnages/Gentil/gauche4.png"));
			
			spritedroite.add(new Image("res/Personnages/Gentil/droite1.png"));
			spritedroite.add(new Image("res/Personnages/Gentil/droite2.png"));
			spritedroite.add(new Image("res/Personnages/Gentil/droite3.png"));
			spritedroite.add(new Image("res/Personnages/Gentil/droite4.png"));
		}
		else
		{
			spritegauche.add(new Image("res/Personnages/Mechant/gauche1.png"));
			spritegauche.add(new Image("res/Personnages/Mechant/gauche2.png"));
			spritegauche.add(new Image("res/Personnages/Mechant/gauche3.png"));
			spritegauche.add(new Image("res/Personnages/Mechant/gauche4.png"));
			
			spritedroite.add(new Image("res/Personnages/Mechant/droite1.png"));
			spritedroite.add(new Image("res/Personnages/Mechant/droite2.png"));
			spritedroite.add(new Image("res/Personnages/Mechant/droite3.png"));
			spritedroite.add(new Image("res/Personnages/Mechant/droite4.png"));
		}
	}

	public void draw(Graphics g)
	{
		arme.draw(g, x, y, direction);
		if(direction == 1)
		{
			g.drawImage(spritedroite.get(right), x, y+1);
		}
		else
		{
			g.drawImage(spritegauche.get(left), x, y+1);
	 	}
		g.setColor(Color.red);
		if(Jeu.debug)
		{
			g.drawRect(x, y, 22, 32);
		}
		arme.draw(g, x, y, direction);
		if(vie >= 20)
			g.setColor(Color.orange);
		if(vie >= 40)
			g.setColor(new Color(0x00ff12));
		
		g.fillRect(x-5, y-8, (30*vie)/100, 3);
		g.setColor(Color.yellow);
		g.fillRect(x-5, y-5  , (30*munitions)/50, 3);
		g.setColor(new Color(0x59c6ef));
		g.fillRect(x-5, y-8, (30*armure)/100, 3);
		g.setColor(new Color(0xff5bf6));
		g.fillRect(x-5, y-12, (30*score)/10, 3);
		//font.drawString(x-5, y-20, "Score : "+String.valueOf(score), new Color(60,60,60));
		balles.draw(g);
	}
	
	public void update()
	{
		y += vy++;
		if(intersect())
		{
			if(vy > 0)
			{
				y = (y/32)*32 - 1;
				jumping = false;
			}
			if(vy < 0)
				y = (y/32 + 1)*32 - 1;
			vy = 0;
		}
		balles.update();
		balles.test(boxs);
		if(timerRegen >= 30)
		{
			vie++;
			timerRegen = 0;
		}
		else if(vie < 100)
		{
			timerRegen++;
		}
		if(Jeu.state == "jeu" || Jeu.state == "zombie")
			Combat.boxs.check(this);
		else
		{
			if(Multi.Multi.imserver == true)
				Serveur.boxs.check(this);
			else
				Client.boxs.check(this);
		}
	}
	public void testBalle(Balles b)
	{
		b.test(this);
	}
	public void testZombie(ArrayList<Zombie> zomb)
	{
		Rectangle me = new Rectangle(x, y, 22,32);
		if(!Jeu.debug)
		for(int i = 0 ; i < zomb.size() ; i++)
		{
			Rectangle zombie = new Rectangle(zomb.get(i).x, zomb.get(i).y, 22,32) ;
			if(me.intersects(zombie))
			{
				if(armure > 0)
					armure = (armure-50 < 0)?0:armure-50;
				else
					vie -= 10;
				zomb.remove(i);
				i--;
			}
		}
	}
	public boolean testMort()
	{
		if(y > 640)
			return true;
		if(vie <= 0)
			return true;
		return false;
	}
	public void tirer() throws SlickException
	{
		if(munitions > 0)
		{

			balles.add(x+7, y+22, id, direction, 2);
			balles.add(x+7, y+22, id, direction, 1);
			balles.add(x+7, y+22, id, direction, 0);
			balles.add(x+7, y+22, id, direction, -1);

			balles.add(x+7, y+22, id, direction, -2);
			//munitions--;
			gunfire.play();
		}
	}
	public void move(int direction)
	{
		if(direction == 1)
		{
			x+=5;
			if(intersect())
				x -= 5;
			counterRight+=2;
			this.direction = 1;
		}
		else
		{
			x-=5;
			if(intersect())
				x+=5;
			counterLeft +=2;
			this.direction = 0;
		}
		if(counterRight > 15)
		{
			if(right != 3)
				right++;
			else
				right = 0;
			counterRight = 0;
		}
		if(counterLeft > 15)
		{
			if(left != 3)
				left++;
			else
				left= 0;
			counterLeft = 0;
		}
	}
	public void jump()
	{
		if(jumping == false || Jeu.debug)
		{
			vy = -14;
			jumping = true;
		}		
	}
	private boolean intersect()
	{
		Rectangle rect = new Rectangle(x+3,y+3,17,29);
		for(int i = 0; i < boxs.size();i++)
			if(boxs.get(i).intersects(rect))
				return true;
		return false;
	}
	public void resetAll() throws SlickException
	{
		this.x = (id == 0)?100:670;
		this.y = 300;
		this.vy = 0;
		direction = (id == 0)?1:0;
		vie = 100;
		right = 0;
		left = 0;
		counterRight = 0;
		counterLeft = 0;
		jumping = false;
		munitions = 50;
		arme = new Arme();
		timeSinceLastFire = 0;
		fireSpeed = 0;
		armure = 0;
	}
	public void set(PacketPersoServer pack) throws SlickException
	{
		this.x = pack.x;
		this.y = pack.y;
		this.vie = pack.vie;
		this.armure = pack.armure;
		this.direction = (pack.direction)?1:0;
		this.munitions = pack.munitions;
		this.counterRight = pack.counterRight;
		this.counterLeft = pack.counterLeft;
		this.score = pack.score;
		if(pack.tir)
		{
			this.tirer();
		}
	}
	public void set(PacketPersoClient pack) throws SlickException
	{
		this.x = pack.x;
		this.y = pack.y;
		this.direction = (pack.direction)?1:0;
		this.counterRight = pack.counterRight;
		this.counterLeft = pack.counterLeft;
		if(pack.fire)
			this.tirer();
	}
}
