package personnage;

import java.util.ArrayList;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Point;

public class Path 
{
	ArrayList<Point> path;
	public Path(int x, int y)
	{
		path = new ArrayList<Point>();
		addPoint(x, y);
	}
	public Path(Path oldpath, int x, int y)
	{
		path = new ArrayList<Point>();
		for(Point p : oldpath.getPath())
			path.add(p);
		addPoint(x, y);
	}
	public Path(Path path) {
		this.path = new ArrayList<Point>();
		for(Point p : path.getPath())
		{
			this.path.add(p);
		}
		// TODO Auto-generated constructor stub
	}
	public ArrayList<Point> getPath()
	{
		return path;
	}
	public void addPoint(int x, int y)
	{
		path.add(new Point(x, y));
	}
	public Point endPoint()
	{
		return path.get(path.size()-1);
	}
	public void addPoint(Point p) {
		path.add(new Point(p.getX(), p.getY()));
	}
	public String toString()
	{
		String result = "";
		for(int i = 0 ; i < path.size() ; i++)
		{
			result += i +": {"+path.get(i).getX()+","+path.get(i).getY()+"}\n";
		}
		return result;
	}
	public void draw(Graphics g) {
		for(int i = 0 ; i < path.size()-1 ; i++)
		{
			g.drawLine(path.get(i).getX()*32 + 16, path.get(i).getY()*32 + 16, path.get(i+1).getX()*32 + 16, path.get(i+1).getY()*32 + 16);
		}
	}
}
