package main;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

import world.Bouton;
import world.Combat;
import world.DrawMap;
import world.Editeur;
import world.ZombieMod;
import Multi.Multi;

public class Jeu extends BasicGameState 
{
	
	// DONE : Munitions
	// TODO? : Diff�rents blocs (caisses en bois etc)
	// TODO : Diff�rentes armes
	// DONE : Armures
	// DONE : R�g�n.
	// TODO : Multi-joueur en ligne (pour plus tard)
	// TODO : Sons
	
	public static final int ID = 1; 
	DrawMap drawmap;
	public static boolean debug = true;
	boolean firststep = false;
	public static String state = "menu";
	Editeur editor;
	Bouton Jeu, Editeur, Multiplayer, Zombie;
	Combat comb;
	public static ZombieMod zomb;
	public static Multi mult;
	public static int time = 0;
	@Override
	public int getID()
	{
		return ID;
	} 
	public void init(GameContainer container, StateBasedGame game) throws SlickException
	{ 
		drawmap = new DrawMap();
		editor = new Editeur();
		Jeu = new Bouton("Combat", 300, 150);
		Editeur = new Bouton("Editeur", 300, 300);
		Zombie = new Bouton("Zombie", 300, 450);
//		Multiplayer = new Bouton("LAN", 300, 450);
		comb = new Combat();
		comb.init();
//		mult = new Multi();
	} 
	public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException 
	{	
		if(state == "jeu")
		{
			comb.draw(g);
		}
		else if(state == "fin")
		{
			if(comb.mechant.score == 10)
				g.drawImage(new Image("res/mechantgagne.png"), 0, 0);
			else
				g.drawImage(new Image("res/gentilgagne.png"), 0, 0);
		}
		else if(state == "editeur")
		{
			editor.render(g);
		}
//		else if(state == "multi")
//		{
//			try {
//				mult.draw(g);
//			} catch (IOException e) {
//				e.printStackTrace();
//			}
//		}
		else if(state == "zombie")
		{
			zomb.draw(g);
		}
		else
		{
			g.setColor(Color.gray);
			g.fillRect(0, 0, 800, 640);
			Jeu.draw(g);
			Editeur.draw(g);
			Zombie.draw(g);
//			Multiplayer.draw(g);
		}
	}
	
	public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException
	{ 
		time++;
		Input in;
		in = container.getInput();
		if(in.isKeyPressed(Input.KEY_F3))
			debug = (debug == false) ? true : false;
		if(state == "jeu")
		{
			if(comb.update(in))
			{
				state = "fin";
			}
			if(in.isKeyPressed(Input.KEY_ESCAPE))
			{
				state = "menu";
			}
		}
		else if(state == "fin")
		{
			if(in.isKeyPressed(Input.KEY_BACK))
			{
				comb.init();
				state = "menu";
			}
		}
		else if(state == "editeur")
		{
			if(editor.update(in))
			{
				comb.init();
				state = "menu";
			}
		}
		else if(state == "zombie")
		{
			if(zomb.update(in))
			{
				state = "menu";
			}
		}
//		else if(state == "multi")
//		{
//			try {
//				mult.update(in);
//			} catch (IOException e) {
//				e.printStackTrace();
//			}
//		}
		else
		{
			if(!in.isMouseButtonDown(0) && firststep)
			{
				if(Jeu.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
				{
					comb.init();
					state = "jeu";
				}
				if(Editeur.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
				{
					state = "editeur";
				}
				if(Zombie.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
				{
					state = "zombie";

					zomb = new ZombieMod();
					zomb.init();
				}
//				if(Multiplayer.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
//				{
//					state = "multi";
//				}
			}
			firststep = in.isMouseButtonDown(0);
		}
	} 
 }