package boxs;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

import personnage.Personnage;
import Multi.Serveur;

public class WorldBoxsServer
{
	public AmmoBoxs muni;
	public MitrailletteBoxs mitraillette;
	public ShieldBoxs armure;
	public HealthBoxs vie;
	int counterMuni = 0, counterMitr = 0, counterArmu = 0, counterVie = 0;
	
	public WorldBoxsServer() throws SlickException
	{
		muni = new AmmoBoxs();
		mitraillette = new MitrailletteBoxs();
		armure = new ShieldBoxs();
		vie = new HealthBoxs();
	}
	
	public void draw(Graphics g)
	{
		mitraillette.draw(g);
		muni.draw(g);
		vie.draw(g);
		armure.draw(g);
	}
	
	public void update()
	{
		 if(counterMuni >= 10*30)
		 {
			 muni.spawn(Serveur.map);
			 counterMuni = 0;
		 }
		 else
		 {
			 counterMuni++;
		 }
		 if(counterVie >= 30*30)
		 {
			 vie.spawn(Serveur.map);
			 counterVie = 0;
		 }
		 else
		 {
			 counterVie++;
		 }
		 if(counterArmu >= 40*30)
		 {
			 armure.spawn(Serveur.map);
			 counterArmu = 0;
		 }
		 else
		 {
			 counterArmu++;
		 }
		 if(counterMitr >= 50*30)
		 {
			 mitraillette.spawn(Serveur.map);
			 counterMitr = 0;
		 }
		 else
		 {
			 counterMitr++;
		 }
	}
	
	public void check(Personnage perso)
	{
		muni.check(perso);
		mitraillette.check(perso);
		armure.check(perso);
		vie.check(perso);
	}
}
