package Multi;

import java.io.IOException;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;

import world.Bouton;

public class Multi
{
	public static String state = "menu";
	public static boolean imserver;
	Bouton Serveur, Client;
	Serveur serv;
	Client client;
	
	public Multi() throws SlickException
	{
		Serveur = new Bouton("Serveur", 300, 200);
		Client = new Bouton("Client", 300, 400);
		serv = new Serveur();
		client = new Client(); 
	}
	
	public void update(Input in) throws IOException, SlickException
	{
		if(state == "menu")
		{
			if(in.isMouseButtonDown(0))
			{
				if(Serveur.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
				{
					imserver = true;
					serv.start();
					state = "pending";
				}
				if(Client.mouseOn(in.getAbsoluteMouseX(), in.getAbsoluteMouseY()))
				{
					imserver = false;
					client.connect("localhost");
					client.start();
					state = "jeu";
				}
			}
		}
		if(state == "jeu")
		{
			if(imserver)
			{
				serv.update(in);
			}
			else
			{
				client.update(in);
			}
		}
		
		
	}
	public void draw(Graphics g) throws IOException
	{
		if(state == "menu")
		{
			g.fillRect(0, 0, 800, 640);
			Serveur.draw(g);
			Client.draw(g);
		}
		if(state == "pending")
		{
			g.fillRect(0, 0, 800, 640);
			Client.font.drawString(100, 300, "Waiting for connection...", new Color(30,30,30));
		}
		if(state == "jeu")
		{
			if(imserver)
			{
				serv.draw(g);
			}
			else
			{
				client.draw(g);
			}
		}
	}
}
