package screens;

import map.Map;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.OrthographicCamera;

import data.GSB;

public class Game  implements Screen
{
	OrthographicCamera camera = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
	Map m;
	
	public Game()
	{
		camera.setToOrtho(false, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
		GSB.init(camera);
		m = new Map(20);
	}
	
	@Override
	public void render(float delta) 
	{
		Gdx.gl.glClearColor(1, 1, 1, 1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
		
		GSB.sb.begin();
		m.render();
		GSB.sb.end();
		
		update(delta);
	}
	
	int cameraSpeed = 3;
	
	public void update(float delta)
	{
		
		if(Gdx.input.getX() < 5)
		{
			camera.translate(-cameraSpeed, 0);
		}
		if(Gdx.input.getX() > Gdx.graphics.getWidth() - 5)
		{
			camera.translate(cameraSpeed, 0);
		}
		if(Gdx.input.getY() < 5)
		{
			camera.translate(0, cameraSpeed);
		}
		if(Gdx.input.getY() > Gdx.graphics.getHeight() - 5)
		{
			camera.translate(0, -cameraSpeed);
		}
		
		camera.update();
		GSB.update(camera);
	}
	
	public void resize(int width, int height) {}
	public void pause() {}
	public void resume() {}
	public void hide() {}
	public void dispose() {}
	public void show() {}
}
