package map;

import data.GSB;
import data.TextureManager;

public class Cell 
{
	int owner = -1;
	int x, y;
	CELL_TYPE type;
	
	enum CELL_TYPE
	{
		EMPTY(1);
		
		private int value;
		
		CELL_TYPE(int v)
		{
			value = v;
		}
		
		public int v()
		{
			return value;
		}
	}
	
	public Cell(int x, int y)
	{
		this.x = x;
		this.y = y;
		type = CELL_TYPE.EMPTY;
	}
	
	public void setType(CELL_TYPE newType)
	{
		type = newType;
	}
	
	public void setOwner(int owner) 
	{
		this.owner = owner;
	}
	
	public void render()
	{
		int drawx = x*80;
		int drawy = y*90 + ((x%2 == 1)?45:0);
		GSB.sb.draw(TextureManager.get("cell"+type.v()+".png"), drawx, drawy);
	}
}
