package data;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;

import java.util.HashMap;
import java.util.Map;

public class TextureManager
{
	
	static Map<String, Texture> textures = new HashMap<String, Texture>();
	/**
	 * This is the main method and is used to get an Texture
	 * @param filename the name of the file with the extension, it's picked in res/
	 * @return an Texture class.
	 */
	public static Texture get(String filename)
	{
		if(textures.get(filename) == null)
		{
			try
			{
				textures.put(filename, new Texture(Gdx.files.internal(filename)));
			}
			catch (Exception e)
			{
				System.out.println("Texture non trouvée : "+ filename);
				e.printStackTrace();
				System.exit(0);
			}
		}
		return textures.get(filename);
	}
	
}
