package mods.immibis.redlogic.lamps;

import java.util.List;
import java.util.Random;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.api.porting.SidedProxy;
import mods.immibis.redlogic.RedLogicMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLampCube extends Block {
	
	private static enum Type {Normal, Decorative, Indicator}
	
	static final int COLOURS[] = {
		0xFFFFFF,
		0xFFA100,
		0xFF00FF,
		0xAEAEFF,
		0xFFFF00,
		0xA1FF63,
		0xFFB9B9,
		0x9D9D9D,
		0xCBCBCB,
		0x00FFFF,
		0xAE00FF,
		0x0000FF,
		0xA55A00,
		0x00A600,
		0xFF0000,
		0x3B3B3B
	};
	
	boolean powered;
	Type type;
	
	static Icon iUncoloured, iColoured;
	static boolean renderingColouredPart;
	
	static int renderType = SidedProxy.instance.getUniqueBlockModelID("mods.immibis.redlogic.lamps.LampRenderStatic", true);
	
	public BlockLampCube(int id, boolean powered, Type type) {
		super(id, Material.redstoneLight);
		this.powered = powered;
		this.type = type;
		
		lightValue[blockID] = (powered && type != Type.Indicator) ? 15 : 0;
		
		if(type == Type.Decorative)
			setCreativeTab(CreativeTabs.tabDecorations);
		else
			setCreativeTab(CreativeTabs.tabRedstone);
		
		switch(type) {
		case Normal: setUnlocalizedName("immibis/redlogic:lamp.cube.n"); break;
		case Decorative: setUnlocalizedName("immibis/redlogic:lamp.cube.d"); break;
		case Indicator: setUnlocalizedName("immibis/redlogic:lamp.cube.i"); break;
		}
		
		setStepSound(soundGlassFootstep);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister par1IconRegister) {
		// load the icons only once
		if(type != Type.Normal || powered)
			return;
		
		iUncoloured = par1IconRegister.registerIcon("immibis/redlogic:lamp/cube-uncoloured");
		iColoured = par1IconRegister.registerIcon("immibis/redlogic:lamp/cube-coloured");
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public Icon getIcon(int par1, int par2) {
		return renderingColouredPart ? iColoured : iUncoloured;
	}
	
	@Override
	public int getRenderType() {
		return renderType;
	}
	
	@Override
	public int damageDropped(int par1) {
		return par1;
	}
	
	@Override
	public void onBlockAdded(World par1World, int par2, int par3, int par4) {
		super.onBlockAdded(par1World, par2, par3, par4);
		onNeighborBlockChange(par1World, par2, par3, par4, 0);
	}
	
	@Override
	public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
		if(par1World.isRemote || type == Type.Decorative)
			return;
		
		boolean nowPowered = isPowered(par1World, par2, par3, par4);
		if(nowPowered != powered)
			par1World.scheduleBlockUpdate(par2, par3, par4, blockID, 1);
	}
	
	@Override
	public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
		if(par1World.isRemote || type == Type.Decorative)
			return;
		
		boolean nowPowered = isPowered(par1World, par2, par3, par4);
		if(nowPowered != powered)
			par1World.setBlock(par2, par3, par4, getOtherBlockID(), par1World.getBlockMetadata(par2, par3, par4), 3);
	}
	
	private boolean isPowered(World w, int x, int y, int z) {
		return w.isBlockIndirectlyGettingPowered(x, y, z);
	}
	
	private int getOtherBlockID() {
		if(type == Type.Normal) {
			if(powered)
				return RedLogicMod.lampCubeOff.blockID;
			else
				return RedLogicMod.lampCubeOn.blockID;
		} else if(type == Type.Indicator) {
			if(powered)
				return RedLogicMod.lampCubeIndicatorOff.blockID;
			else
				return RedLogicMod.lampCubeIndicatorOn.blockID;
		} else {
			return blockID;
		}
	}
	
	@Override
	public int idPicked(World par1World, int par2, int par3, int par4) {
        if(type != Type.Decorative && powered)
        	return getOtherBlockID();
        else
        	return super.idPicked(par1World, par2, par3, par4);
    }
	
	@Override
	@SideOnly(Side.CLIENT)
	public int colorMultiplier(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
		return getRenderColor(par1iBlockAccess.getBlockMetadata(par2, par3, par4));
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public int getRenderColor(int par1) {
		if(!renderingColouredPart)
			return 0xFFFFFF;
		
		try {
			int c = COLOURS[par1];
			if(!powered)
				c = (c >> 2) & 0x3F3F3F;
			return c;
		} catch(ArrayIndexOutOfBoundsException e) {
			return 0;
		}
	}
	
	public static class On extends BlockLampCube {public On(int id) {super(id, true, Type.Normal);}}
	public static class Off extends BlockLampCube {public Off(int id) {super(id, false, Type.Normal);}}
	public static class Decorative extends BlockLampCube {public Decorative(int id) {super(id, true, Type.Decorative);}}
	public static class IndicatorOn extends BlockLampCube {public IndicatorOn(int id) {super(id, true, Type.Indicator);}}
	public static class IndicatorOff extends BlockLampCube {public IndicatorOff(int id) {super(id, false, Type.Indicator);}}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		if(powered && type != Type.Decorative)
			return;
		
		for(int k = 0; k < 16; k++)
			par3List.add(new ItemStack(this, 1, k));
	}
	
	/*@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
		par1World.removeBlockTileEntity(par2, par3, par4);
	}
	
	@Override
	public void onBlockAdded(World par1World, int par2, int par3, int par4) {
		super.onBlockAdded(par1World, par2, par3, par4);
		par1World.setBlockTileEntity(par2, par3, par4, new TileLampCubeOn());
	}*/
}
