package info.jbcs.minecraft.chisel.utilities;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3Pool;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;

public class FakeWorld implements IBlockAccess {
	Block block;
	int blockId;
	public int metadata;
	
	public void setBlock(Block b){
		blockId=b.blockID;
		block=b;
	}
	
	@Override
	public int getBlockId(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return blockId;
		
		return 0;
	}

	@Override
	public TileEntity getBlockTileEntity(int i, int j, int k) {
		return null;
	}

	@Override
	public int getLightBrightnessForSkyBlocks(int i, int j, int k, int l) {
		return 15 << 20;
	}

	@Override
	public int getBlockMetadata(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return metadata;
		
		return 0;
	}

	@Override
	public float getBrightness(int i, int j, int k, int l) {
		return 0.5f;
	}

	@Override
	public float getLightBrightness(int i, int j, int k) {
		return 0.5f;
	}

	@Override
	public Material getBlockMaterial(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return block.blockMaterial;		
		
		return Material.air;
	}

	@Override
	public boolean isBlockOpaqueCube(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return block.isOpaqueCube();		

		return false;
	}

	@Override
	public boolean isBlockNormalCube(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return block.isNormalCube(blockId);	
		
		return false;
	}

	@Override
	public boolean isAirBlock(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return false;	
		
		return true;
	}

	@Override
	public BiomeGenBase getBiomeGenForCoords(int i, int j) {
		return null;
	}

	@Override
	public int getHeight() {
		return 128;
	}

	@Override
	public boolean extendedLevelsInChunkCache() {
		return false;
	}

	@Override
	public boolean doesBlockHaveSolidTopSurface(int i, int j, int k) {
		if(i==0 && j==0 && k==0) return true;	
		
		return false;
	}

    private final Vec3Pool vecPool = new Vec3Pool(1,1);
	@Override
	public Vec3Pool getWorldVec3Pool() {
		return vecPool;
	}

	@Override
	public int isBlockProvidingPowerTo(int i, int j, int k, int l) {
		return 0;
	}

	// @Override
	public boolean isBlockSolidOnSide(int x, int y, int z, ForgeDirection side, boolean _default) {
		return true;
	}

}
