package info.jbcs.minecraft.chisel;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemCarvable extends ItemBlock {
	int blockId;

	public ItemCarvable(int id) {
		super(id);
		setMaxDamage(0);
		setHasSubtypes(true);
		blockId=id+256;
	}

	@Override
	public int getMetadata(int i) {
		return i;
	}

	@Override
	public String getUnlocalizedName(ItemStack itemstack) {
		return "item." + Block.blocksList[blockId].getUnlocalizedName() + "." + itemstack.getItemDamage();
	}
	
    @Override
	public Icon getIconFromDamage(int damage) {
        return Block.blocksList[blockId].getIcon(2,damage);
    }

}
