package mods.immibis.am2;

import ic2.core.block.BlockTextureStitched;

import java.util.ArrayList;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import mods.immibis.core.BlockCombined;
import mods.immibis.core.api.util.Dir;

public class BlockAM2 extends BlockCombined {
	
	public static final int META_MACERATOR = 0;
	public static final int META_COMPRESSOR = 1;
	public static final int META_EXTRACTOR = 2;
	public static final int META_ELECTROLYZER = 3;
	public static final int META_DEELECTROLYZER = 4;
	public static final int META_RECYCLER = 5;

	public BlockAM2(int i) {
		super(i, Material.iron, "", new String[0]);
	}
	
	private Icon[][] icons;
	private int[][] sideAndFacingToSpriteOffset = { { 3, 2, 0, 0, 0, 0 }, { 2, 3, 1, 1, 1, 1 }, { 1, 1, 3, 2, 5, 4 }, { 0, 0, 2, 3, 4, 5 }, { 4, 5, 4, 5, 3, 2 }, { 5, 4, 5, 4, 2, 3 } };
	
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister par1IconRegister) {
		
		icons = new Icon[16][12];
		
		String[] names = {"macerator", "compressor", "extractor", null, null, null, null, null, null, null, null, null, null, null, null, null};
		
		for(int k = 0; k < 16; k++)
			if(names[k] != null) {
				for(int i = 0; i < 12; i++) {
					String iName = "immibis/am2:" + names[k] + "." + i;
					icons[k][i] = new BlockTextureStitched(iName);
					if(par1IconRegister instanceof TextureMap)
						((TextureMap)par1IconRegister).setTextureEntry(iName, (BlockTextureStitched)icons[k][i]);
				}
			}
	}
	
	@SideOnly(Side.CLIENT)
	public Icon getIcon(int side, int data, int facing, boolean active) {
		return icons[data][sideAndFacingToSpriteOffset[side][facing] + (active ? 6 : 0)];
	}
	
	@Override
	public Icon getIcon(int side, int data) {
		return getIcon(side, data, Dir.PZ, false);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public Icon getBlockTexture(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
		try {
			TileAM2Base te = (TileAM2Base)par1iBlockAccess.getBlockTileEntity(par2, par3, par4);
			return getIcon(par5, par1iBlockAccess.getBlockMetadata(par2, par3, par4), te.getFacing(), te.isVisuallyActive());
		} catch(Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case META_MACERATOR:
			return new TileAM2Macerator();
		case META_COMPRESSOR:
			return new TileAM2Compressor();
		case META_EXTRACTOR:
			return new TileAM2Extractor();
		}
		return null;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public void addCreativeItems(ArrayList arraylist) {
		arraylist.add(new ItemStack(this, 1, META_MACERATOR));
		arraylist.add(new ItemStack(this, 1, META_COMPRESSOR));
		arraylist.add(new ItemStack(this, 1, META_EXTRACTOR));
	}
	
	@Override
	public boolean canProvidePower() {
		return false;
	}
	
	@Override
	public boolean isOpaqueCube() {
		return true;
	}
}
