package mods.immibis.am2;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import mods.immibis.cobaltite.AssignedBlock;
import mods.immibis.cobaltite.CobaltiteMod;
import mods.immibis.cobaltite.Configurable;
import mods.immibis.cobaltite.ModBase;
import mods.immibis.cobaltite.TileGUI;
import mods.immibis.cobaltite.CobaltiteMod.RegisteredTile;
import mods.immibis.core.api.FMLModInfo;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(modid = "AdvancedMachines", version = "55.0.3", dependencies = "required-after:IC2;required-after:ImmibisCore", name = "Advanced Machines")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
@CobaltiteMod(tiles = {
	@RegisteredTile(id = "Rotary Macerator", tile = TileAM2Macerator.class),
	@RegisteredTile(id = "Singularity Compressor", tile = TileAM2Compressor.class),
	@RegisteredTile(id = "Centrifuge Extractor", tile = TileAM2Extractor.class)
})
@FMLModInfo(authors="immibis", description="Upgraded Macerator, Extractor and Compressor", url="http://www.minecraftforum.net/topic/1001131-/")
public class AdvancedMachines extends ModBase {
	@AssignedBlock(id = "block", item = ItemAM2.class)
	public static BlockAM2 block;
	
	@TileGUI(container = ContainerAM2.class, gui = GuiAM2.class)
	public static final int GUI_PROCESSOR = 0;

	@Instance("AdvancedMachines")
	public static AdvancedMachines INSTANCE;
	
	@Configurable("idleEUPerTick")
	public static int idleEUPerTick = 1;
	
	@Configurable("runningEUPerTick")
	public static int runningEUPerTick = 16;
	
	@Configurable("maxVoltage")
	public static int maxVoltage = 128;
	
	@Override
	protected void addRecipes() throws Exception {
		GameRegistry.addRecipe(new ItemStack(block, 1, BlockAM2.META_MACERATOR),
			"###",
			"#M#",
			"#X#",
			'#', ic2.api.item.Items.getItem("refinedIronIngot"),
			'M', ic2.api.item.Items.getItem("macerator"),
			'X', ic2.api.item.Items.getItem("advancedMachine"));
		GameRegistry.addRecipe(new ItemStack(block, 1, BlockAM2.META_EXTRACTOR),
			"###",
			"#M#",
			"#X#",
			'#', ic2.api.item.Items.getItem("electrolyzedWaterCell"),
			'M', ic2.api.item.Items.getItem("extractor"),
			'X', ic2.api.item.Items.getItem("advancedMachine"));
		GameRegistry.addRecipe(new ItemStack(block, 1, BlockAM2.META_COMPRESSOR),
			"###",
			"#M#",
			"#X#",
			'#', Block.obsidian,
			'M', ic2.api.item.Items.getItem("compressor"),
			'X', ic2.api.item.Items.getItem("advancedMachine"));
	}
	
	@PreInit
	public void base_preinit(FMLPreInitializationEvent evt) {super._preinit(evt);}
	@Init
	public void base_init(FMLInitializationEvent evt) {super._init(evt);}
}
