package JAKJ . RedstoneInMotion ;

import net . minecraft . tileentity . TileEntity ;
import net . minecraft . world . World ;
import net . minecraft . world . chunk . Chunk ;
import net . minecraft . world . chunk . storage . ExtendedBlockStorage ;

public abstract class WorldUtil
{
	public static void MarkDirtyForServer ( World World , int X , int Y , int Z )
	{
		World . getChunkFromBlockCoords ( X , Z ) . setChunkModified ( ) ;
	}

	public static void MarkDirtyForServer ( net . minecraft . tileentity . TileEntity TileEntity )
	{
		MarkDirtyForServer ( TileEntity . worldObj , TileEntity . xCoord , TileEntity . yCoord , TileEntity . zCoord ) ;
	}

	public static void MarkBlockChanged ( World World , int X , int Y , int Z )
	{
		World . markBlockForUpdate ( X , Y , Z ) ;

		World . notifyBlockChange ( X , Y , Z , World . getBlockId ( X , Y , Z ) ) ;
	}

	public static void MarkBlockChanged ( net . minecraft . tileentity . TileEntity TileEntity )
	{
		MarkBlockChanged ( TileEntity . worldObj , TileEntity . xCoord , TileEntity . yCoord , TileEntity . zCoord ) ;
	}

	public static void Propagate ( World World , int X , int Y , int Z )
	{
		MarkDirtyForServer ( World , X , Y , Z ) ;

		MarkBlockChanged ( World , X , Y , Z ) ;
	}

	public static void Propagate ( net . minecraft . tileentity . TileEntity TileEntity )
	{
		Propagate ( TileEntity . worldObj , TileEntity . xCoord , TileEntity . yCoord , TileEntity . zCoord ) ;
	}

	public static void MarkDirtyForClient ( World World , int X , int Y , int Z )
	{
		World . markBlockForRenderUpdate ( X , Y , Z ) ;
	}

	public static void MarkDirtyForClient ( net . minecraft . tileentity . TileEntity TileEntity )
	{
		MarkDirtyForClient ( TileEntity . worldObj , TileEntity . xCoord , TileEntity . yCoord , TileEntity . zCoord ) ;
	}

	public static void ClearBlock ( World World , int X , int Y , int Z )
	{
		SetBlock ( World , X , Y , Z , 0 , 0 ) ;
	}

	public static void SetBlock ( World World , int X , int Y , int Z , int Id , int Meta )
	{
		World . setBlock ( X , Y , Z , Id , Meta , 0x3 ) ;
	}

	public static void RefreshBlock ( World World , int X , int Y , int Z , int OldId , int NewId )
	{
		UpdateLighting ( World , X , Y , Z ) ;

		NotifyBlocks ( World , X , Y , Z , OldId , NewId ) ;
	}

	public static void NotifyBlocks ( World World , int X , int Y , int Z , int OldId , int NewId )
	{
		World . notifyBlockChange ( X , Y , Z , OldId ) ;

		if ( NewId == 0 )
		{
			return ;
		}

		if ( Block . Get ( NewId ) . hasComparatorInputOverride ( ) )
		{
			World . func_96440_m ( X , Y , Z , NewId ) ;
		}
	}

	public static void SneakySetBlock ( net . minecraft . world . World World , int X , int Y , int Z , int Id , int Meta )
	{
		net . minecraft . world . chunk . Chunk Chunk = World . getChunkFromBlockCoords ( X , Z ) ;

		int ChunkX = X & 0xF ;
		int ChunkY = Y & 0xF ;
		int ChunkZ = Z & 0xF ;

		Chunk . removeChunkBlockTileEntity ( ChunkX , Y , ChunkZ ) ;

		int LayerY = Y >> 4 ;

		if ( Chunk . storageArrays [ LayerY ] == null )
		{
			Chunk . storageArrays [ LayerY ] = new net . minecraft . world . chunk . storage . ExtendedBlockStorage ( ( LayerY ) << 4 , ! World . provider . hasNoSky ) ;
		}

		Chunk . storageArrays [ LayerY ] . setExtBlockID ( ChunkX , ChunkY , ChunkZ , Id ) ;

		Chunk . storageArrays [ LayerY ] . setExtBlockMetadata ( ChunkX , ChunkY , ChunkZ , Meta ) ;

		Chunk . isModified = true ;

		World . markBlockForUpdate ( X , Y , Z ) ;
	}
	/* logic messed up - y >= heightmapvalue as flag only if extended block storage created */ /* recheck logic */
	public static void UpdateLighting ( net . minecraft . world . World World , int X , int Y , int Z )
	{
		net . minecraft . world . chunk . Chunk Chunk = World . getChunkFromBlockCoords ( X , Z ) ;

		int ChunkX = X & 0xF ;
		int ChunkY = Y & 0xF ;
		int ChunkZ = Z & 0xF ;

		int HeightMapIndex = ChunkZ << 4 | ChunkX ;

		if ( Y >= Chunk . precipitationHeightMap [ HeightMapIndex ] - 1 )
		{
			Chunk . precipitationHeightMap [ HeightMapIndex ] = -999 ;
		}

		int HeightMapValue = Chunk . heightMap [ HeightMapIndex ] ;

		if ( Y >= HeightMapValue )
		{
			Chunk . generateSkylightMap ( ) ;
		}
		else
		{
			if ( Chunk . getBlockLightOpacity ( ChunkX , Y , ChunkZ ) > 0 )
			{
				if ( Y >= HeightMapValue )
				{
					Chunk . relightBlock ( ChunkX , Y + 1 , ChunkZ ) ;
				}
			}
			else if ( Y == HeightMapValue - 1 )
			{
				Chunk . relightBlock ( ChunkX , Y , ChunkZ ) ;
			}

			Chunk . propagateSkylightOcclusion ( ChunkX , ChunkZ ) ;
		}

		World . updateAllLightTypes ( X , Y , Z ) ;
	}
}
