package JAKJ . RedstoneInMotion ;

public abstract class Registry
{
	public static Object [ ] UnwrapPattern ( Object [ ] Pattern )
	{
		for ( int Index = 0 ; Index < Pattern . length ; Index ++ )
		{
			if ( Pattern [ Index ] instanceof Stack )
			{
				Pattern [ Index ] = ( ( Stack ) Pattern [ Index ] ) . Stack ;
			}
		}

		return ( Pattern ) ;
	}

	public static void RegisterCustomRecipe ( net . minecraft . item . crafting . IRecipe Recipe )
	{
		cpw . mods . fml . common . registry . GameRegistry . addRecipe ( Recipe ) ;
	}

	public static void RegisterShapelessRecipe ( Stack Result , Object ... Pattern )
	{
		cpw . mods . fml . common . registry . GameRegistry . addShapelessRecipe ( Result . Stack , UnwrapPattern ( Pattern ) ) ;
	}

	public static void RegisterShapedRecipe ( Stack Result , Object ... Pattern )
	{
		cpw . mods . fml . common . registry . GameRegistry . addShapedRecipe ( Result . Stack , UnwrapPattern ( Pattern ) ) ;
	}

	public static void RegisterSmeltingRecipe ( Stack Output , Stack Input )
	{
		RegisterSmeltingRecipe ( Output , Input , 0 ) ;
	}

	public static void RegisterSmeltingRecipe ( Stack Output , Stack Input , float Xp )
	{
		net . minecraft . item . crafting . FurnaceRecipes . smelting ( ) . addSmelting ( Input . GetId ( ) , Input . GetDamage ( ) , Output . Stack , Xp ) ;
	}

	public static void RegisterItem ( Item Item )
	{
		cpw . mods . fml . common . registry . GameRegistry . registerItem ( Item , Item . getUnlocalizedName ( ) , Core . Handle ) ;
	}

	public static void RegisterBlock ( net . minecraft . block . Block Block , Class < ? extends net . minecraft . item . ItemBlock > BlockItemClass )
	{
		cpw . mods . fml . common . registry . GameRegistry . registerBlock ( Block , BlockItemClass , Block . getUnlocalizedName ( ) , Core . Handle ) ;
	}

	public abstract static class HarvestToolTypes
	{
		public static String Pickaxe = "pickaxe" ;

		public static String Hatchet = "axe" ;
	}

	public static void RegisterHarvestTool ( net . minecraft . block . Block Block , String ToolType )
	{
		net . minecraftforge . common . MinecraftForge . setBlockHarvestLevel ( Block , ToolType , 0 ) ;
	}

	public static void RegisterTileEntity ( Class < ? extends net . minecraft . tileentity . TileEntity > Class )
	{
		cpw . mods . fml . common . registry . GameRegistry . registerTileEntity ( Class , Core . Handle + "_" + Class . getSimpleName ( ) ) ;
	}

	public static void RegisterEventHandler ( Object EventHandler )
	{
		net . minecraftforge . common . MinecraftForge . EVENT_BUS . register ( EventHandler ) ;
	}

	public static net . minecraft . util . Icon RegisterIcon ( net . minecraft . client . renderer . texture . IconRegister IconRegister , String Handle )
	{
		return ( IconRegister . registerIcon ( Core . Handle + ":" + Configuration . TextureSets . values ( ) [ Configuration . TextureSets . TextureSet ] . name ( ) + "/" + Handle ) ) ;
	}
}
