package JAKJ . RedstoneInMotion ;

public class MotiveSpectreRenderer extends TileEntityRenderer
{
	@Override
	public void Render ( net . minecraft . tileentity . TileEntity TileEntity , float PartialTick )
	{
		MotiveSpectreEntity Spectre = ( MotiveSpectreEntity ) TileEntity ;

		if ( Spectre . Motion == null )
		{
			return ;
		}

		{
			double Offset = Spectre . Velocity * ( Spectre . TicksExisted + PartialTick ) ;

			Render . Translate ( Offset * Spectre . Motion . DeltaX - Spectre . xCoord , Offset * Spectre . Motion . DeltaY - Spectre . yCoord , Offset * Spectre . Motion . DeltaZ - Spectre . zCoord ) ;
		}

//		Render . ExecuteDisplayList ( Spectre . DisplayList ) ;

		Integer DisplayList = CarriageRenderCache . Lookup ( Spectre . xCoord , Spectre . yCoord , Spectre . zCoord ) ;

		if ( DisplayList != null )
		{
			Render . ExecuteDisplayList ( DisplayList ) ;
		}
	}

	public static void FillDisplayList ( MotiveSpectreEntity Spectre )
	{
		MotiveSpectreRendererWorld World = new MotiveSpectreRendererWorld ( Spectre . worldObj , Spectre . Body ) ;

		net . minecraft . client . renderer . RenderBlocks BlockRenderer = new net . minecraft . client . renderer . RenderBlocks ( World ) ;

		for ( BlockRecord Record : Spectre . Body )
		{
			boolean Rendered = false ;

			if ( Block . Get ( Record . Id ) . getRenderType ( ) >= 0 )
			{
				RenderEngine . ResetBoundTexture ( ) ;

				RenderEngine . BindBlockTexture ( null ) ;

				BlockRenderer . renderAllFaces = true ;

				net . minecraft . client . renderer . Tessellator . instance . startDrawingQuads ( ) ;

				try
				{
					Rendered = BlockRenderer . renderBlockByRenderType ( Block . Get ( Record . Id ) , Record . X , Record . Y , Record . Z ) ;
				}
				catch ( Throwable Throwable )
				{
					Throwable . printStackTrace ( ) ;
				}

				net . minecraft . client . renderer . Tessellator . instance . draw ( ) ;
			}

			if ( Record . Entity != null )
			{
				net . minecraft . client . renderer . tileentity . TileEntitySpecialRenderer TileEntityRenderer ;

				TileEntityRenderer = net . minecraft . client . renderer . tileentity . TileEntityRenderer . instance . getSpecialRendererForEntity ( Record . Entity ) ;

				if ( TileEntityRenderer != null )
				{
					net . minecraft . world . World RealWorld = TileEntityRenderer . tileEntityRenderer . worldObj ;

					TileEntityRenderer . tileEntityRenderer . worldObj = World ;

					TileEntityRenderer . tileEntityRenderer . renderEngine . resetBoundTexture ( ) ;

					net . minecraft . client . renderer . RenderHelper . enableStandardItemLighting ( ) ;

					Render . PushMatrix ( ) ;

					try
					{
						TileEntityRenderer . renderTileEntityAt ( Record . Entity , Record . X , Record . Y , Record . Z , 0 ) ;
					}
					catch ( Throwable Throwable )
					{
						Throwable . printStackTrace ( ) ;
					}

					Render . PopMatrix ( ) ;

					net . minecraft . client . renderer . RenderHelper . disableStandardItemLighting ( ) ;

					TileEntityRenderer . tileEntityRenderer . worldObj = RealWorld ;

					Rendered = true ;
				}
			}

			if ( ! Rendered )
			{
				RenderEngine . ResetBoundTexture ( ) ;

				RenderEngine . BindBlockTexture ( null ) ;

				BlockRenderer . renderAllFaces = true ;

				net . minecraft . client . renderer . Tessellator . instance . startDrawingQuads ( ) ;

				BlockRenderer . setRenderBounds ( 0 , 0 , 0 , 1 , 1 , 1 ) ;

				BlockRenderer . renderStandardBlock ( Blocks . Spectre , Record . X , Record . Y , Record . Z ) ;

				net . minecraft . client . renderer . Tessellator . instance . draw ( ) ;
			}
		}
	}
}
