package JAKJ . RedstoneInMotion ;

public class MotiveSpectreEntity extends net . minecraft . tileentity . TileEntity
{
	public int DisplayList ;

	public int TicksExisted ;

	public static int MotionDuration = 20 ;

	public static double Velocity = 1 / ( ( double ) MotionDuration ) ;

	public Directions Motion ;

	public int DriveX ;
	public int DriveY ;
	public int DriveZ ;

	public BlockRecordSet Body ;

	public net . minecraft . nbt . NBTTagList PendingBlockUpdates ;

	@Override
	public void updateEntity ( )
	{
		TicksExisted ++ ;

		for ( CapturedEntity Entity : CapturedEntities )
		{
			Entity . Update ( ) ;
		}

		if ( worldObj . isRemote )
		{
			return ;
		}

		if ( Motion == null )
		{
			WorldUtil . SetBlock ( worldObj , xCoord , yCoord , zCoord , 0 , 0 ) ;

			return ;
		}

		if ( TicksExisted < MotionDuration )
		{
			return ;
		}

		for ( BlockRecord Record : Body )
		{
			Record . Shift ( Motion ) ;

			WorldUtil . SneakySetBlock ( worldObj , Record . X , Record . Y , Record . Z , Record . Id , Record . Meta ) ;
		}

		for ( BlockRecord Record : Body )
		{
//			net . minecraft . block . Block . blocksList [ Record . Id ] . onBlockAdded ( worldObj , Record . X , Record . Y , Record . Z ) ;

			if ( Record . EntityRecord != null )
			{
				Record . Entity = net . minecraft . tileentity . TileEntity . createAndLoadEntity ( Record . EntityRecord ) ;

				worldObj . setBlockTileEntity ( Record . X , Record . Y , Record . Z , Record . Entity ) ;
			}
		}

		try
		{
			( ( CarriageDriveEntity ) worldObj . getBlockTileEntity ( DriveX , DriveY , DriveZ ) ) . ToggleActivity ( ) ;
		}
		catch ( Throwable Throwable )
		{
			Throwable . printStackTrace ( ) ;
		}

		WorldUtil . RefreshBlock ( worldObj , xCoord , yCoord , zCoord , Blocks . Spectre . blockID , 0 ) ;

		for ( BlockRecord Record : Body )
		{
			WorldUtil . RefreshBlock ( worldObj , Record . X , Record . Y , Record . Z , 0 , Record . Id ) ;
		}

		int PendingBlockUpdateCount = PendingBlockUpdates . tagCount ( ) ;

		for ( int Index = 0 ; Index < PendingBlockUpdateCount ; Index ++ )
		{
			net . minecraft . nbt . NBTTagCompound PendingBlockUpdateRecord = ( net . minecraft . nbt . NBTTagCompound ) PendingBlockUpdates . tagAt ( Index ) ;

			worldObj . scheduleBlockUpdateFromLoad
			(
				PendingBlockUpdateRecord . getInteger ( "X" ) + Motion . DeltaX ,
				PendingBlockUpdateRecord . getInteger ( "Y" ) + Motion . DeltaY ,
				PendingBlockUpdateRecord . getInteger ( "Z" ) + Motion . DeltaZ ,

				PendingBlockUpdateRecord . getInteger ( "Id" ) ,

				PendingBlockUpdateRecord . getInteger ( "Delay" ) ,

				PendingBlockUpdateRecord . getInteger ( "Foo" )
			) ;
		}
	}

	@Override
	public void invalidate ( )
	{
		if ( worldObj . isRemote )
		{
//			Render . ReleaseDisplayList ( DisplayList ) ;

			CarriageRenderCache . Release ( xCoord , yCoord , zCoord ) ;
		}

		super . invalidate ( ) ;
	}

	public void WriteToNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		if ( Motion == null )
		{
			return ;
		}

		TagCompound . setInteger ( "Motion" , Motion . ordinal ( ) ) ;

		{
			net . minecraft . nbt . NBTTagList BodyRecord = new net . minecraft . nbt . NBTTagList ( ) ;

			for ( BlockRecord Record : Body )
			{
				net . minecraft . nbt . NBTTagCompound BodyBlockRecord = new net . minecraft . nbt . NBTTagCompound ( ) ;

				BodyBlockRecord . setInteger ( "X" , Record . X ) ;
				BodyBlockRecord . setInteger ( "Y" , Record . Y ) ;
				BodyBlockRecord . setInteger ( "Z" , Record . Z ) ;

				BodyBlockRecord . setInteger ( "Id" , Record . Id ) ;

				BodyBlockRecord . setInteger ( "Meta" , Record . Meta ) ;

				if ( Record . EntityRecord != null )
				{
					BodyBlockRecord . setCompoundTag ( "EntityRecord" , Record . EntityRecord ) ;

					if ( Record . EntityPacketRecord != null )
					{
						BodyBlockRecord . setCompoundTag ( "EntityPacketRecord" , Record . EntityPacketRecord ) ;
					}
				}

				BodyRecord . appendTag ( BodyBlockRecord ) ;
			}

			TagCompound . setTag ( "Body" , BodyRecord ) ;
		}
	}

	@Override
	public void writeToNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . writeToNBT ( TagCompound ) ;

		WriteToNbt ( TagCompound ) ;

		TagCompound . setInteger ( "DriveX" , DriveX ) ;
		TagCompound . setInteger ( "DriveY" , DriveY ) ;
		TagCompound . setInteger ( "DriveZ" , DriveZ ) ;

		TagCompound . setTag ( "PendingBlockUpdates" , PendingBlockUpdates ) ;
	}

	@Override
	public net . minecraft . network . packet . Packet132TileEntityData getDescriptionPacket ( )
	{
		net . minecraft . network . packet . Packet132TileEntityData Packet = new net . minecraft . network . packet . Packet132TileEntityData ( xCoord , yCoord , zCoord , 0 , new net . minecraft . nbt . NBTTagCompound ( ) ) ;

		WriteToNbt ( Packet . customParam1 ) ;

		{
			net . minecraft . nbt . NBTTagList CapturedEntityRecords = new net . minecraft . nbt . NBTTagList ( ) ;

			for ( CapturedEntity Entity : CapturedEntities )
			{
				net . minecraft . nbt . NBTTagCompound CapturedEntityRecord = new net . minecraft . nbt . NBTTagCompound ( ) ;

				CapturedEntityRecord . setInteger ( "Id" , Entity . Entity . entityId ) ;

				CapturedEntityRecord . setDouble ( "InitialX" , Entity . InitialX ) ;
				CapturedEntityRecord . setDouble ( "InitialY" , Entity . InitialY ) ;
				CapturedEntityRecord . setDouble ( "InitialZ" , Entity . InitialZ ) ;

				CapturedEntityRecords . appendTag ( CapturedEntityRecord ) ;
			}

			Packet . customParam1 . setTag ( "CapturedEntities" , CapturedEntityRecords ) ;
		}

		return ( Packet ) ;
	}

	public void ReadFromNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		Motion = Directions . values ( ) [ TagCompound . getInteger ( "Motion" ) ] ;

		Body = new BlockRecordSet ( ) ;

		{
			net . minecraft . nbt . NBTTagList BodyRecord = TagCompound . getTagList ( "Body" ) ;

			int BodyBlockCount = BodyRecord . tagCount ( ) ;

			for ( int Index = 0 ; Index < BodyBlockCount ; Index ++ )
			{
				net . minecraft . nbt . NBTTagCompound BodyBlockRecord = ( net . minecraft . nbt . NBTTagCompound ) BodyRecord . tagAt ( Index ) ;

				BlockRecord Record = new BlockRecord ( BodyBlockRecord . getInteger ( "X" ) , BodyBlockRecord . getInteger ( "Y" ) , BodyBlockRecord . getInteger ( "Z" ) ) ;

				Record . Id = BodyBlockRecord . getInteger ( "Id" ) ;

				Record . Meta = BodyBlockRecord . getInteger ( "Meta" ) ;

				if ( BodyBlockRecord . hasKey ( "EntityRecord" ) )
				{
					Record . EntityRecord = BodyBlockRecord . getCompoundTag ( "EntityRecord" ) ;

					if ( BodyBlockRecord . hasKey ( "EntityPacketRecord" ) )
					{
						Record . EntityPacketRecord = BodyBlockRecord . getCompoundTag ( "EntityPacketRecord" ) ;
					}
				}

				Body . add ( Record ) ;
			}
		}
	}

	@Override
	public void readFromNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . readFromNBT ( TagCompound ) ;

		ReadFromNbt ( TagCompound ) ;

		DriveX = TagCompound . getInteger ( "DriveX" ) ;
		DriveY = TagCompound . getInteger ( "DriveY" ) ;
		DriveZ = TagCompound . getInteger ( "DriveZ" ) ;

		PendingBlockUpdates = TagCompound . getTagList ( "PendingBlockUpdates" ) ;
	}

	@Override
	public void onDataPacket ( net . minecraft . network . INetworkManager NetworkManager , net . minecraft . network . packet . Packet132TileEntityData Packet )
	{
		ReadFromNbt ( Packet . customParam1 ) ;

		{
			net . minecraft . nbt . NBTTagList CapturedEntityRecords = Packet . customParam1 . getTagList ( "CapturedEntities" ) ;

			CapturedEntities . clear ( ) ;

			int CapturedEntityCount = CapturedEntityRecords . tagCount ( ) ;

			for ( int Index = 0 ; Index < CapturedEntityCount ; Index ++ )
			{
				net . minecraft . nbt . NBTTagCompound EntityRecord = ( net . minecraft . nbt . NBTTagCompound ) CapturedEntityRecords . tagAt ( Index ) ;

				net . minecraft . entity . Entity Entity = worldObj . getEntityByID ( EntityRecord . getInteger ( "Id" ) ) ;

				if ( Entity == null )
				{
					continue ;
				}

				CapturedEntities . add ( new CapturedEntity ( Entity , EntityRecord . getDouble ( "InitialX" ) , EntityRecord . getDouble ( "InitialY" ) , EntityRecord . getDouble ( "InitialZ" ) ) ) ;
			}
		}
/*
		Render . ReleaseDisplayList ( DisplayList ) ;

		DisplayList = Render . InitializeDisplayList ( ) ;

		MotiveSpectreRenderer . FillDisplayList ( this ) ;

		Render . FinalizeDisplayList ( ) ;
*/
	}

	public class CapturedEntity
	{
		public net . minecraft . entity . Entity Entity ;

		public double InitialX ;
		public double InitialY ;
		public double InitialZ ;

		boolean WasOnGround ;

		boolean WasAirBorne ;

		public CapturedEntity ( net . minecraft . entity . Entity Entity )
		{
			this ( Entity , Entity . posX , Entity . posY , Entity . posZ ) ;
		}

		public CapturedEntity ( net . minecraft . entity . Entity Entity , double InitialX , double InitialY , double InitialZ )
		{
			this . Entity = Entity ;

			this . InitialX = InitialX ;
			this . InitialY = InitialY ;
			this . InitialZ = InitialZ ;

			WasOnGround = Entity . onGround ;

			WasAirBorne = Entity . isAirBorne ;

			Update ( ) ;
		}

		public void SetPosition ( double OffsetX , double OffsetY , double OffsetZ )
		{
			Entity . setPosition ( InitialX + OffsetX , InitialY + OffsetY + Entity . yOffset , InitialZ + OffsetZ ) ;
		}

		public void Update ( )
		{
			Entity . fallDistance = 0 ;

			if ( TicksExisted == MotionDuration )
			{
				Entity . motionX = 0 ;
				Entity . motionY = 0 ;
				Entity . motionZ = 0 ;

				SetPosition ( Motion . DeltaX , Motion . DeltaY , Motion . DeltaZ ) ;

				Entity . prevPosX = Entity . posX ;
				Entity . prevPosY = Entity . posY ;
				Entity . prevPosZ = Entity . posZ ;

				Entity . onGround = WasOnGround ;

				Entity . isAirBorne = WasAirBorne ;

				return ;
			}

			Entity . onGround = false ;

			Entity . isAirBorne = true ;

			Entity . motionX = Velocity * Motion . DeltaX ;
			Entity . motionY = Velocity * Motion . DeltaY ;
			Entity . motionZ = Velocity * Motion . DeltaZ ;

			SetPosition ( Entity . motionX * TicksExisted , Entity . motionY * TicksExisted , Entity . motionZ * TicksExisted ) ;

			Entity . prevPosX = Entity . posX - Entity . motionX ;
			Entity . prevPosY = Entity . posY - Entity . motionY ;
			Entity . prevPosZ = Entity . posZ - Entity . motionZ ;
		}
	}

	public java . util . ArrayList < CapturedEntity > CapturedEntities = new java . util . ArrayList < CapturedEntity > ( ) ;

	public void Absorb ( CarriagePackage Package )
	{
		Motion = Package . MotionDirection ;

		Body = Package . Blocks ;

		DriveX = Package . DriveRecord . X ;
		DriveY = Package . DriveRecord . Y ;
		DriveZ = Package . DriveRecord . Z ;

		if ( ! Package . DriveIsAnchored )
		{
			DriveX += Motion . DeltaX ;
			DriveY += Motion . DeltaY ;
			DriveZ += Motion . DeltaZ ;
		}

		PendingBlockUpdates = Package . PendingBlockUpdates ;

		{
			net . minecraft . util . AxisAlignedBB EntityCaptureBox = net . minecraft . util . AxisAlignedBB . getBoundingBox
			(
				Package . MinX - 5 , Package . MinY - 5 , Package . MinZ - 5 , Package . MaxX + 5 , Package . MaxY + 5 , Package . MaxZ + 5
			) ;

			java . util . List EntitiesFound = Package . World . getEntitiesWithinAABB ( net . minecraft . entity . Entity . class , EntityCaptureBox ) ;

			for ( Object EntityObject : EntitiesFound )
			{
				net . minecraft . entity . Entity Entity = ( net . minecraft . entity . Entity ) EntityObject ;

				BlockRecord PositionCheck = new BlockRecord ( ( int ) Math . floor ( Entity . posX ) , ( int ) Math . floor ( Entity . posY ) , ( int ) Math . floor ( Entity . posZ ) ) ;

				if ( ! Body . contains ( PositionCheck ) )
				{
					PositionCheck . Y -- ;

					if ( ! Body . contains ( PositionCheck ) )
					{
						PositionCheck . Y -- ;

						if ( ! Body . contains ( PositionCheck ) )
						{
							Entity = null ;
						}
					}
				}

				if ( Entity == null )
				{
					continue ;
				}

				if ( Entity instanceof net . minecraft . entity . player . EntityPlayer )
				{
					if ( ! Configuration . CarriageMotion . CapturePlayerEntities )
					{
						continue ;
					}
				}
				else if ( Entity instanceof net . minecraft . entity . EntityLiving )
				{
					if ( ! Configuration . CarriageMotion . CaptureOtherLivingEntities )
					{
						continue ;
					}
				}
				else if ( Entity instanceof net . minecraft . entity . item . EntityItem )
				{
					if ( ! Configuration . CarriageMotion . CaptureItemEntities )
					{
						continue ;
					}
				}
				else if ( ! Configuration . CarriageMotion . CaptureOtherEntities )
				{
					continue ;
				}

				CapturedEntities . add ( new CapturedEntity ( ( net . minecraft . entity . Entity ) Entity ) ) ;
			}
		}

		WorldUtil . Propagate ( this ) ;
	}

	@Override
	public net . minecraft . util . AxisAlignedBB getRenderBoundingBox ( )
	{
		return ( INFINITE_EXTENT_AABB ) ;
	}
}
