package JAKJ . RedstoneInMotion ;

public class Configuration
{
	public abstract static class BlockIds
	{
		public static String Category = "BlockIds" ;

		public static int Carriage ;

		public static int CarriageDrive ;

		public static int Spectre ;
	}

	public abstract static class Carriage
	{
		public static String Category = "Carriage" ;

		public static int MaxPlatformBurden = 5000 ;

		public static int MaxSupportBurden = 5000 ;
	}

	public abstract static class CarriageDrive
	{
		public static String Category = "Carriage Drive" ;

		public static int ContinuousCooldown = 5 ;
	}

	public abstract static class CarriageMotion
	{
		public static String Category = "Carriage Motion" ;

		public static boolean CapturePlayerEntities = true ;

		public static boolean CaptureOtherLivingEntities = true ;

		public static boolean CaptureItemEntities = true ;

		public static boolean CaptureOtherEntities = true ;
	}

	public enum TextureSets
	{
		JAKJ ( "default 256x textures" ) ,
		cubemelon ( "16x textures by cubemelon" ) ,
		JustHev ( "16x textures (with support for colourblindness) by JustHev" ) ,
		uberifix_wood ( "16x wood-style textures by uberifix" ) ,
		uberifix_metal ( "16x metal-style textures (with support for colourblindness) by uberifix" ) ;

		public static String Category = "Texture Sets" ;

		public String Description ;

		private TextureSets ( String Description )
		{
			this . Description = Description ;
		}

		public static int TextureSet ;
	}

	public net . minecraftforge . common . Configuration Configuration ;

	public Configuration ( java . io . File File )
	{
		Configuration = new net . minecraftforge . common . Configuration ( File , true ) ;
	}

	public String String ( String Category , String Name , String Default )
	{
		return ( Configuration . get ( Category , Name , Default ) . getString ( ) ) ;
	}

	public boolean Boolean ( String Category , String Name , boolean Default )
	{
		return ( Configuration . get ( Category , Name , Default ) . getBoolean ( Default ) ) ;
	}

	public int Integer ( String Category , String Name , int Default )
	{
		return ( Configuration . get ( Category , Name , Default ) . getInt ( Default ) ) ;
	}

	public int BoundedInteger ( String Category , String Name , int Min , int Default , int Max )
	{
		int Value = Integer ( Category , Name , Default ) ;

		if ( Value < Min )
		{
			new RuntimeException ( Name + " must be at least " + Min ) . printStackTrace ( ) ;

			return ( Default ) ;
		}

		if ( Value > Max )
		{
			new RuntimeException ( Name + " must be at most " + Max ) . printStackTrace ( ) ;

			return ( Default ) ;
		}

		return ( Value ) ;
	}

	public int BlockId ( String Name , int Default )
	{
		return ( Configuration . getBlock ( BlockIds . Category , Name , Default ) . getInt ( Default ) ) ;
	}

	public int ItemId ( String Name , int Default )
	{
		return ( Configuration . getItem ( "Item IDs" , Name , Default ) . getInt ( Default ) ) ;
	}

	public void Process ( )
	{
		{
			BlockIds . Carriage = BlockId ( "Carriages" , 1123 ) ;

			BlockIds . CarriageDrive = BlockId ( "Carriage Drives" , 1124 ) ;

			BlockIds . Spectre = BlockId ( "Motive Spectre" , 1125 ) ;
		}

		{
			ToolItemSet . Id = ItemId ( "Tools" , 11235 ) ;

			SimpleItemSet . Id = ItemId ( "Simple Items" , 11236 ) ;
		}

		{
			{
				String Blacklist = String ( Carriage . Category , "Blacklist" , "" ) ;

				if ( ! Blacklist . equals ( "" ) )
				{
					for ( String BlacklistItem : Blacklist . split ( "," ) )
					{
						String [ ] BlacklistItemElements = BlacklistItem . split ( ":" ) ;

						try
						{
							if ( BlacklistItemElements . length == 1 )
							{
								CarriagePackageBlacklist . Add ( Integer . parseInt ( BlacklistItemElements [ 0 ] ) ) ;

								continue ;
							}

							if ( BlacklistItemElements . length == 2 )
							{
								CarriagePackageBlacklist . Add ( Integer . parseInt ( BlacklistItemElements [ 0 ] ) , Integer . parseInt ( BlacklistItemElements [ 1 ] ) ) ;

								continue ;
							}
						}
						catch ( Throwable Throwable )
						{
							Throwable . printStackTrace ( ) ;
						}

						new RuntimeException ( "Invalid blacklist item: " + BlacklistItem ) . printStackTrace ( ) ;
					}
				}
			}

			CarriagePackage . MaxBlockCount = BoundedInteger ( Carriage . Category , "Maximum size of any carriage (0 = no limit)" , 0 , CarriagePackage . MaxBlockCount , Integer . MAX_VALUE ) ;

			Carriage . MaxPlatformBurden = BoundedInteger ( Carriage . Category , "Maximum blocks carried by platform carriage" , 1 , Carriage . MaxPlatformBurden , Integer . MAX_VALUE ) ;

			Carriage . MaxSupportBurden = BoundedInteger ( Carriage . Category , "Maximum blocks carried by a support carriage" , 1 , Carriage . MaxSupportBurden , Integer . MAX_VALUE ) ;
		}

		{
			CarriageDrive . ContinuousCooldown = BoundedInteger ( CarriageDrive . Category , "Cooldown (in ticks) between motions in continuous mode" , 5 , CarriageDrive . ContinuousCooldown , Integer . MAX_VALUE ) ;
		}

		{
			String Category = "Carriage Motion" ;

			CarriageMotion . CapturePlayerEntities = Boolean ( Category , "Should grab players during motion" , CarriageMotion . CapturePlayerEntities ) ;

			CarriageMotion . CaptureOtherLivingEntities = Boolean ( Category , "Should grab non-player living entities during motion" , CarriageMotion . CaptureOtherLivingEntities ) ;

			CarriageMotion . CaptureItemEntities = Boolean ( Category , "Should grab floating items during motion" , CarriageMotion . CaptureItemEntities ) ;

			CarriageMotion . CaptureOtherEntities = Boolean ( Category , "Should grab all other miscellaneous entities during motion" , CarriageMotion . CaptureOtherEntities ) ;

			CarriagePackage . ObstructedByLiquids = Boolean ( Category , "Carriage motion is obstructed by liquids" , CarriagePackage . ObstructedByLiquids ) ;

			CarriagePackage . ObstructedByFragileBlocks = Boolean ( Category , "Carriage motion is obstructed by fragile blocks like tall grass" , CarriagePackage . ObstructedByFragileBlocks ) ;
		}

		{
			int TextureSetCount = TextureSets . values ( ) . length ;

			TextureSets . TextureSet = BoundedInteger ( TextureSets . Category , "Index of texture set" , 0 , TextureSets . TextureSet , TextureSetCount - 1 ) ;

			String TextureSetDescriptions = "" ;

			for ( TextureSets TextureSet : TextureSets . values ( ) )
			{
				if ( TextureSet . ordinal ( ) > 0 )
				{
					TextureSetDescriptions += "\n" ;
				}

				TextureSetDescriptions += TextureSet . ordinal ( ) + " - " + TextureSet . Description ;
			}

			Configuration . addCustomCategoryComment ( TextureSets . Category , TextureSetDescriptions ) ;
		}

		Configuration . save ( ) ;
	}
}
