package JAKJ . RedstoneInMotion ;

public abstract class CarriageRenderCache
{
	public static java . util . TreeMap < BlockRecord , Integer > Cache = new java . util . TreeMap < BlockRecord , Integer > ( ) ;

	public static void Render ( net . minecraft . client . renderer . RenderBlocks BlockRenderer , BlockRecordList Blocks , BlockRecordList TileEntities , int Pass )
	{
		net . minecraft . client . renderer . RenderHelper . disableStandardItemLighting ( ) ;

		{
			RenderEngine . ResetBoundTexture ( ) ;

			RenderEngine . BindBlockTexture ( null ) ;

			Render . PushMatrix ( ) ;

			net . minecraft . client . renderer . Tessellator . instance . startDrawingQuads ( ) ;

			for ( BlockRecord Record : Blocks )
			{
				if ( ! net . minecraft . block . Block . blocksList [ Record . Id ] . canRenderInPass ( Pass ) )
				{
					continue ;
				}

				BlockRenderer . renderAllFaces = true ;

				try
				{
					BlockRenderer . renderBlockByRenderType ( net . minecraft . block . Block . blocksList [ Record . Id ] , Record . X , Record . Y , Record . Z ) ;
				}
				catch ( Throwable Throwable )
				{
					Throwable . printStackTrace ( ) ;
				}
			}

			net . minecraft . client . renderer . Tessellator . instance . draw ( ) ;

			Render . PopMatrix ( ) ;
		}

		net . minecraft . client . renderer . RenderHelper . enableStandardItemLighting ( ) ;

		{
			Render . PushMatrix ( ) ;

			Render . Translate
			(
				net . minecraft . client . renderer . tileentity . TileEntityRenderer . instance . staticPlayerX ,
				net . minecraft . client . renderer . tileentity . TileEntityRenderer . instance . staticPlayerY ,
				net . minecraft . client . renderer . tileentity . TileEntityRenderer . instance . staticPlayerZ
			) ;

			for ( BlockRecord Record : TileEntities )
			{
				if ( ! Record . Entity . shouldRenderInPass ( Pass ) )
				{
					continue ;
				}

				RenderEngine . ResetBoundTexture ( ) ;

				RenderEngine . BindBlockTexture ( null ) ;

				RenderEngine . ResetBoundTexture ( ) ;

				Render . PushMatrix ( ) ;

				try
				{
					net . minecraft . client . renderer . tileentity . TileEntityRenderer . instance . renderTileEntity ( Record . Entity , 0 ) ;
				}
				catch ( Throwable Throwable )
				{
					Throwable . printStackTrace ( ) ;
				}

				Render . PopMatrix ( ) ;
			}

			Render . PopMatrix ( ) ;
		}
	}

	public static void Assemble ( int AnchorX , int AnchorY , int AnchorZ , BlockRecordList Blocks , BlockRecordList TileEntities , net . minecraft . world . World World )
	{
		net . minecraft . client . renderer . RenderBlocks BlockRenderer = new net . minecraft . client . renderer . RenderBlocks ( World ) ;

		int DisplayList = Render . InitializeDisplayList ( ) ;

		{
			Render ( BlockRenderer , Blocks , TileEntities , 0 ) ;
		}

		{
			org . lwjgl . opengl . GL11 . glDisable ( org . lwjgl . opengl . GL11 . GL_CULL_FACE ) ;

			org . lwjgl . opengl . GL11 . glEnable ( org . lwjgl . opengl . GL11 . GL_BLEND ) ;

			org . lwjgl . opengl . GL11 . glBlendFunc ( org . lwjgl . opengl . GL11 . GL_SRC_ALPHA , org . lwjgl . opengl . GL11 . GL_ONE_MINUS_SRC_ALPHA ) ;

			Render ( BlockRenderer , Blocks , TileEntities , 1 ) ;

			org . lwjgl . opengl . GL11 . glDisable ( org . lwjgl . opengl . GL11 . GL_BLEND ) ;

			org . lwjgl . opengl . GL11 . glEnable ( org . lwjgl . opengl . GL11 . GL_CULL_FACE ) ;
		}

		Render . FinalizeDisplayList ( ) ;

		Cache . put ( new BlockRecord ( AnchorX , AnchorY , AnchorZ ) , DisplayList ) ;
	}

	public static Integer Lookup ( int AnchorX , int AnchorY , int AnchorZ )
	{
		return ( Cache . get ( new BlockRecord ( AnchorX , AnchorY , AnchorZ ) ) ) ;
	}

	public static void Release ( int AnchorX , int AnchorY , int AnchorZ )
	{
		Integer DisplayList = Cache . remove ( new BlockRecord ( AnchorX , AnchorY , AnchorZ ) ) ;

		if ( DisplayList != null )
		{
			Render . ReleaseDisplayList ( DisplayList ) ;
		}
	}
}
