package JAKJ . RedstoneInMotion ;

public class CarriageMotorEntity extends CarriageDriveEntity
{
	@Override
	public CarriagePackage GeneratePackage ( CarriageEntity Carriage , Directions CarriageDirection , Directions MotionDirection ) throws CarriageMotionException
	{
		if ( MotionDirection == CarriageDirection )
		{
			throw ( new CarriageMotionException ( "motor cannot push carriage away from itself" ) ) ;
		}

		if ( MotionDirection == CarriageDirection . Opposite ( ) )
		{
			throw ( new CarriageMotionException ( "motor cannot pull carriage into itself" ) ) ;
		}

		CarriagePackage Package = new CarriagePackage ( this , Carriage , MotionDirection ) ;

		Carriage . FillPackage ( Package ) ;

		if ( Package . Blocks . contains ( Package . DriveRecord ) )
		{
			throw ( new CarriageMotionException ( "carriage is attempting to move motor" ) ) ;
		}

		if ( Package . Blocks . contains ( Package . DriveRecord . NextInDirection ( MotionDirection . Opposite ( ) ) ) )
		{
			throw ( new CarriageMotionException ( "carriage motion is obstructed by motor" ) ) ;
		}

		Package . Finalize ( ) ;

		return ( Package ) ;
	}

	@Override
	public boolean Anchored ( )
	{
		return ( true ) ;
	}
}
