package JAKJ . RedstoneInMotion ;

public abstract class CarriageDriveEntity extends net . minecraft . tileentity . TileEntity
{
	public boolean Continuous ;

	public void ToggleContinuity ( )
	{
		Continuous = ! Continuous ;

		WorldUtil . Propagate ( this ) ;
	}

	public boolean Active ;

	public int CooldownRemaining ;

	public void ToggleActivity ( )
	{
		if ( Active && Continuous )
		{
			CooldownRemaining = Configuration . CarriageDrive . ContinuousCooldown ;
		}

		Active = ! Active ;

		WorldUtil . Propagate ( this ) ;
	}

	public Directions CarriageDirection ;

	public Directions SignalDirection ;

	public void HandleNeighbourBlockChange ( )
	{
		CarriageDirection = null ;

		boolean CarriageDirectionValid = true ;

		SignalDirection = null ;

		boolean SignalDirectionValid = true ;

		for ( Directions Direction : Directions . values ( ) )
		{
			int X = xCoord + Direction . DeltaX ;
			int Y = yCoord + Direction . DeltaY ;
			int Z = zCoord + Direction . DeltaZ ;

			if ( worldObj . isAirBlock ( X , Y , Z ) )
			{
				continue ;
			}

			int Id = worldObj . getBlockId ( X , Y , Z ) ;

			if ( Id == Blocks . Carriage . blockID )
			{
				if ( CarriageDirection != null )
				{
					CarriageDirectionValid = false ;
				}
				else
				{
					CarriageDirection = Direction ;
				}
			}
			else if ( net . minecraft . block . Block . blocksList [ Id ] . isProvidingWeakPower ( worldObj , X , Y , Z , Direction . ordinal ( ) ) > 0 )
			{
				if ( SignalDirection != null )
				{
					SignalDirectionValid = false ;
				}
				else
				{
					SignalDirection = Direction ;
				}
			}
		}

		if ( ! CarriageDirectionValid )
		{
			CarriageDirection = null ;
		}

		if ( ! SignalDirectionValid )
		{
			SignalDirection = null ;
		}
	}

	public boolean Signalled ;

	@Override
	public void readFromNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . readFromNBT ( TagCompound ) ;

		Active = TagCompound . getBoolean ( "Active" ) ;

		Continuous = TagCompound . getBoolean ( "Continuous" ) ;

		Signalled = TagCompound . getBoolean ( "Signalled" ) ;

		CooldownRemaining = TagCompound . getInteger ( "CooldownRemaining" ) ;
	}

	@Override
	public void onDataPacket ( net . minecraft . network . INetworkManager NetworkManager , net . minecraft . network . packet . Packet132TileEntityData Packet )
	{
		Active = Packet . customParam1 . getBoolean ( "Active" ) ;

		Continuous = Packet . customParam1 . getBoolean ( "Continuous" ) ;

		WorldUtil . MarkDirtyForClient ( this ) ;
	}

	@Override
	public void writeToNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . writeToNBT ( TagCompound ) ;

		TagCompound . setBoolean ( "Active" , Active ) ;

		TagCompound . setBoolean ( "Continuous" , Continuous ) ;

		TagCompound . setBoolean ( "Signalled" , Signalled ) ;

		TagCompound . setInteger ( "CooldownRemaining" , CooldownRemaining ) ;
	}

	@Override
	public net . minecraft . network . packet . Packet132TileEntityData getDescriptionPacket ( )
	{
		net . minecraft . network . packet . Packet132TileEntityData Packet = new net . minecraft . network . packet . Packet132TileEntityData ( xCoord , yCoord , zCoord , 0 , new net . minecraft . nbt . NBTTagCompound ( ) ) ;

		Packet . customParam1 . setBoolean ( "Active" , Active ) ;

		Packet . customParam1 . setBoolean ( "Continuous" , Continuous ) ;

		return ( Packet ) ;
	}

	@Override
	public void validate ( )
	{
		super . validate ( ) ;

		if ( ! worldObj . isRemote )
		{
			worldObj . scheduleBlockUpdate ( xCoord , yCoord , zCoord , Blocks . CarriageDrive . blockID , 1 ) ;
		}
	}

	@Override
	public void updateEntity ( )
	{
		if ( worldObj . isRemote )
		{
			return ;
		}

		if ( CooldownRemaining > 0 )
		{
			CooldownRemaining -- ;

			WorldUtil . MarkDirtyForServer ( this ) ;

			return ;
		}

		if ( Active )
		{
			return ;
		}

		if ( SignalDirection == null )
		{
			if ( Signalled )
			{
				Signalled = false ;

				WorldUtil . MarkDirtyForServer ( this ) ;
			}

			return ;
		}

		if ( CarriageDirection == null )
		{
			return ;
		}

		if ( Signalled )
		{
			if ( ! Continuous )
			{
				return ;
			}
		}
		else
		{
			Signalled = true ;

			WorldUtil . MarkDirtyForServer ( this ) ;
		}

		try
		{
			BeginMotion ( SignalDirection . Opposite ( ) , false ) ;
		}
		catch ( CarriageMotionException Exception )
		{
		}
	}

	public void BeginMotion ( Directions MotionDirection , boolean Simulate ) throws CarriageMotionException
	{
		CarriageEntity Carriage = ( CarriageEntity ) worldObj . getBlockTileEntity ( xCoord + CarriageDirection . DeltaX , yCoord + CarriageDirection . DeltaY , zCoord + CarriageDirection . DeltaZ ) ;

		ToggleActivity ( ) ;

		CarriagePackage Package ;

		try
		{
			Package = GeneratePackage ( Carriage , CarriageDirection , MotionDirection ) ;
		}
		catch ( CarriageMotionException Exception )
		{
			ToggleActivity ( ) ;

			throw ( Exception ) ;
		}

		if ( Simulate )
		{
			ToggleActivity ( ) ;

			return ;
		}

		PacketHandler . DispatchPacket ( Package ) ;

		for ( BlockRecord Record : Package . Blocks )
		{
			Record . Entity = null ;

			if ( Package . NewPositions . contains ( Record ) )
			{
				WorldUtil . SneakySetBlock ( worldObj , Record . X , Record . Y , Record . Z , Blocks . Spectre . blockID , Spectre . Types . Supportive . ordinal ( ) ) ;
			}
			else
			{
				WorldUtil . SneakySetBlock ( worldObj , Record . X , Record . Y , Record . Z , 0 , 0 ) ;
			}
		}

		for ( BlockRecord Record : Package . Blocks )
		{
			WorldUtil . RefreshBlock ( worldObj , Record . X , Record . Y , Record . Z , Record . Id , 0 ) ;
		}

		int CarriageX = Carriage . xCoord + MotionDirection . DeltaX ;
		int CarriageY = Carriage . yCoord + MotionDirection . DeltaY ;
		int CarriageZ = Carriage . zCoord + MotionDirection . DeltaZ ;

		WorldUtil . SetBlock ( worldObj , CarriageX , CarriageY , CarriageZ , Blocks . Spectre . blockID , Spectre . Types . Motive . ordinal ( ) ) ;

		( ( MotiveSpectreEntity ) worldObj . getBlockTileEntity ( CarriageX , CarriageY , CarriageZ ) ) . Absorb ( Package ) ;
	}

	public abstract CarriagePackage GeneratePackage ( CarriageEntity Carriage , Directions CarriageDirection , Directions MotionDirection ) throws CarriageMotionException ;

	public abstract boolean Anchored ( ) ;
}
