package JAKJ . RedstoneInMotion ;

public class CarriageDrive extends net . minecraft . block . Block
{
	public static boolean ControllerAvailable ;

	public CarriageDrive ( )
	{
		super ( Configuration . BlockIds . CarriageDrive , new net . minecraft . block . material . Material ( blockIron . blockMaterial . materialMapColor ) ) ;

		setUnlocalizedName ( Core . Handle + "_" + getClass ( ) . getSimpleName ( ) ) ;

		setHardness ( blockIron . blockHardness ) ;

		setStepSound ( blockIron . stepSound ) ;

		Registry . RegisterBlock ( this , CarriageDriveItem . class ) ;

		Registry . RegisterHarvestTool ( this , Registry . HarvestToolTypes . Pickaxe ) ;

		{
			Registry . RegisterTileEntity ( CarriageEngineEntity . class ) ;

			Registry . RegisterTileEntity ( CarriageMotorEntity . class ) ;

			{
				Class < ? extends CarriageDriveEntity > ControllerClass = null ;

				try
				{
					ControllerClass = ( Class < ? extends CarriageDriveEntity > ) Class . forName ( "JAKJ.RedstoneInMotion.CarriageControllerEntity" ) ;
				}
				catch ( Throwable Throwable )
				{
				}

				if ( ControllerClass != null )
				{
					Registry . RegisterTileEntity ( ControllerClass ) ;

					ControllerAvailable = true ;
				}
			}
		}

		setCreativeTab ( CreativeTab . Instance ) ;
	}

	public enum Types
	{
		Engine ,
		Motor ,
		Controller ;

		public net . minecraft . util . Icon NormalIcon ;

		public net . minecraft . util . Icon ContinuousIcon ;

		public net . minecraft . util . Icon NormalActiveIcon ;

		public net . minecraft . util . Icon ContinuousActiveIcon ;
	}

	@Override
	public void getSubBlocks ( int Id , net . minecraft . creativetab . CreativeTabs CreativeTab , java . util . List List )
	{
		for ( Types Type : Types . values ( ) )
		{
			if ( ( Type == Types . Controller ) && ( ! ControllerAvailable ) )
			{
				continue ;
			}

			List . add ( Stack . New ( this , Type . ordinal ( ) ) ) ;
		}
	}

	@Override
	public boolean hasTileEntity ( int Meta )
	{
		if ( Meta < 0 )
		{
			return ( false ) ;
		}

		if ( Meta >= Types . values ( ) . length )
		{
			return ( false ) ;
		}

		return ( true ) ;
	}

	@Override
	public net . minecraft . tileentity . TileEntity createTileEntity ( net . minecraft . world . World WOrld , int Meta )
	{
		switch ( Types . values ( ) [ Meta ] )
		{
			case Engine :

				return ( new CarriageEngineEntity ( ) ) ;

			case Motor :

				return ( new CarriageMotorEntity ( ) ) ;

			case Controller :

				if ( ControllerAvailable )
				{
					try
					{
						return ( ( net . minecraft . tileentity . TileEntity ) Class . forName ( "JAKJ.RedstoneInMotion.CarriageControllerEntity" ) . newInstance ( ) ) ;
					}
					catch ( Throwable Throwable )
					{
						throw ( new RuntimeException ( Throwable ) ) ;
					}
				}

				break ;
		}

		return ( null ) ;
	}

	@Override
	public void registerIcons ( net . minecraft . client . renderer . texture . IconRegister IconRegister )
	{
		for ( Types Type : Types . values ( ) )
		{
			Type . NormalIcon = Registry . RegisterIcon ( IconRegister , "Carriage" + Type . name ( ) ) ;

			if ( Type != Types . Controller )
			{
				Type . ContinuousIcon = Registry . RegisterIcon ( IconRegister , "Carriage" + Type . name ( ) + "_Continuous" ) ;
			}

			Type . NormalActiveIcon = Registry . RegisterIcon ( IconRegister , "Carriage" + Type . name ( ) + "_Active" ) ;

			if ( Type != Types . Controller )
			{
				Type . ContinuousActiveIcon = Registry . RegisterIcon ( IconRegister , "Carriage" + Type . name ( ) + "_Continuous_Active" ) ;
			}
		}
	}

	@Override
	public net . minecraft . util . Icon getIcon ( int Side , int Meta )
	{
		return ( Types . values ( ) [ Meta ] . NormalIcon ) ;
	}

	@Override
	public net . minecraft . util . Icon getBlockTexture ( net . minecraft . world . IBlockAccess World , int X , int Y , int Z , int Side )
	{
		CarriageDriveEntity Drive = ( CarriageDriveEntity ) World . getBlockTileEntity ( X , Y , Z ) ;

		Types Type = Types . values ( ) [ World . getBlockMetadata ( X , Y , Z ) ] ;

		if ( Drive . Continuous )
		{
			return ( Drive . Active ? Type . ContinuousActiveIcon : Type . ContinuousIcon ) ;
		}

		return ( Drive . Active ? Type . NormalActiveIcon : Type . NormalIcon ) ;
	}

	@Override
	public boolean onBlockActivated ( net . minecraft . world . World World , int X , int Y , int Z , net . minecraft . entity . player . EntityPlayer Player , int Side , float HitX , float HitY , float HitZ )
	{
		if ( World . isRemote )
		{
			return ( false ) ;
		}

		if ( ! ToolItemSet . IsScrewdriverOrEquivalent ( Player . inventory . getCurrentItem ( ) ) )
		{
			return ( false ) ;
		}

		( ( CarriageDriveEntity ) World . getBlockTileEntity ( X , Y , Z ) ) . ToggleContinuity ( ) ;

		return ( true ) ;
	}

	@Override
	public int damageDropped ( int Meta )
	{
		return ( Meta ) ;
	}

	@Override
	public void updateTick ( net . minecraft . world . World World , int X , int Y , int Z , java . util . Random Random )
	{
		( ( CarriageDriveEntity ) World . getBlockTileEntity ( X , Y , Z ) ) . HandleNeighbourBlockChange ( ) ;
	}

	@Override
	public void onNeighborBlockChange ( net . minecraft . world . World World , int X , int Y , int Z , int Id )
	{
		( ( CarriageDriveEntity ) World . getBlockTileEntity ( X , Y , Z ) ) . HandleNeighbourBlockChange ( ) ;
	}
}
