package JAKJ . RedstoneInMotion ;

public class CarriageControllerEntity extends CarriageDriveEntity implements dan200 . computer . api . IPeripheral
{
	@Override
	public void ToggleContinuity ( )
	{
	}

	@Override
	public void updateEntity ( )
	{
	}

	public boolean Anchored ;

	@Override
	public boolean Anchored ( )
	{
		return ( Anchored ) ;
	}

	@Override
	public String getType ( )
	{
		return ( "JAKJ_RIM_CarriageController" ) ;
	}

	@Override
	public boolean canAttachToSide ( int Side )
	{
		return ( true ) ;
	}

	@Override
	public void attach ( dan200 . computer . api . IComputerAccess Computer )
	{
	}

	@Override
	public void detach ( dan200 . computer . api . IComputerAccess Computer )
	{
	}

	@Override
	public String [ ] getMethodNames ( )
	{
		return ( new String [ ] { "move" } ) ;
	}

	@Override
	public Object [ ] callMethod ( dan200 . computer . api . IComputerAccess Computer , int MethodIndex , Object [ ] Arguments ) throws Exception
	{
		if ( MethodIndex == 0 )
		{
			if ( Arguments . length < 3 )
			{
				throw ( new Exception ( "too few arguments" ) ) ;
			}

			if ( Arguments . length > 3 )
			{
				throw ( new Exception ( "too many arguments" ) ) ;
			}

			Directions MotionDirection ;

			try
			{
				MotionDirection = Directions . values ( ) [ ( int ) Math . round ( ( Double ) Arguments [ 0 ] ) ] ;
			}
			catch ( Throwable Throwable )
			{
				throw ( new Exception ( "invalid direction" ) ) ;
			}

			boolean Simulate ;

			try
			{
				Simulate = ( Boolean ) Arguments [ 1 ] ;
			}
			catch ( Throwable Throwable )
			{
				throw ( new Exception ( "invalid simulation flag" ) ) ;
			}

			try
			{
				Anchored = ( Boolean ) Arguments [ 2 ] ;
			}
			catch ( Throwable Throwable )
			{
				throw ( new Exception ( "invalid anchoring flag" ) ) ;
			}

			return ( Move ( MotionDirection , Simulate ) ) ;
		}

		throw ( new Exception ( "no such command" ) ) ;
	}

	public Object [ ] Move ( Directions MotionDirection , boolean Simulate ) throws CarriageMotionException
	{
		if ( Active )
		{
			throw ( new CarriageMotionException ( "controller already active" ) ) ;
		}

		if ( CarriageDirection == null )
		{
			throw ( new CarriageMotionException ( "no carriage or too many carriages attached to controller" ) ) ;
		}

		BeginMotion ( MotionDirection , Simulate ) ;

		return ( new Object [ ] { true } ) ;
	}

	@Override
	public CarriagePackage GeneratePackage ( CarriageEntity Carriage , Directions CarriageDirection , Directions MotionDirection ) throws CarriageMotionException
	{
		CarriagePackage Package ;

		if ( Anchored )
		{
			if ( MotionDirection == CarriageDirection )
			{
				throw ( new CarriageMotionException ( "cannot push carriage away from controller in anchored mode" ) ) ;
			}

			if ( MotionDirection == CarriageDirection . Opposite ( ) )
			{
				throw ( new CarriageMotionException ( "cannot pull carriage into controller in anchored mode" ) ) ;
			}

			Package = new CarriagePackage ( this , Carriage , MotionDirection ) ;

			Carriage . FillPackage ( Package ) ;

			if ( Package . Blocks . contains ( Package . DriveRecord ) )
			{
				throw ( new CarriageMotionException ( "carriage is attempting to move controller while in anchored mode" ) ) ;
			}

			if ( Package . Blocks . contains ( Package . DriveRecord . NextInDirection ( MotionDirection . Opposite ( ) ) ) )
			{
				throw ( new CarriageMotionException ( "carriage is obstructed by controller while in anchored mode" ) ) ;
			}
		}
		else
		{
			Package = new CarriagePackage ( this , Carriage , MotionDirection ) ;

			Package . AddBlock ( Package . DriveRecord ) ;

			if ( MotionDirection != CarriageDirection )
			{
				Package . AddPotentialObstruction ( Package . DriveRecord . NextInDirection ( MotionDirection ) ) ;
			}

			Carriage . FillPackage ( Package ) ;
		}

		Package . Finalize ( ) ;

		return ( Package ) ;
	}
}
