package JAKJ . RedstoneInMotion ;

public class TemplateCarriageEntity extends CarriageEntity
{
	public BlockRecordSet Pattern ;

	@Override
	public void ToggleSide ( int Side , boolean Sneaking )
	{
		if ( Pattern == null )
		{
			AbsorbPattern ( ) ;

			if ( Pattern == null )
			{
				return ;
			}
		}
		else
		{
			RenderPattern = ! RenderPattern ;
		}

		WorldUtil . Propagate ( this ) ;
	}

	public void AbsorbPattern ( )
	{
		Pattern = new BlockRecordSet ( ) ;

		BlockRecordSet BlocksChecked = new BlockRecordSet ( ) ;

		BlocksChecked . add ( new BlockRecord ( xCoord , yCoord , zCoord ) ) ;

		BlockRecordSet BlocksToCheck = new BlockRecordSet ( ) ;

		BlocksToCheck . add ( new BlockRecord ( xCoord , yCoord , zCoord ) ) ;

		while ( BlocksToCheck . size ( ) > 0 )
		{
			BlockRecord Record = BlocksToCheck . pollFirst ( ) ;

			for ( Directions Direction : Directions . values ( ) )
			{
				BlockRecord NextRecord = Record . NextInDirection ( Direction ) ;

				if ( ! BlocksChecked . add ( NextRecord ) )
				{
					continue ;
				}

				NextRecord . Identify ( this ) ;

				if ( NextRecord . Id == Blocks . Carriage . blockID )
				{
					if ( NextRecord . Meta == Carriage . Types . Template . ordinal ( ) )
					{
						if ( ( ( TemplateCarriageEntity ) NextRecord . Entity ) . Pattern == null )
						{
							Pattern . add ( new BlockRecord ( NextRecord ) ) ;

							BlocksToCheck . add ( NextRecord ) ;
						}
					}
				}
			}
		}

		if ( Pattern . size ( ) == 0 )
		{
			Pattern = null ;

			return ;
		}

		for ( BlockRecord PatternBlock : Pattern )
		{
			WorldUtil . ClearBlock ( worldObj , PatternBlock . X , PatternBlock . Y , PatternBlock . Z ) ;

			PatternBlock . X -= xCoord ;
			PatternBlock . Y -= yCoord ;
			PatternBlock . Z -= zCoord ;
		}

		for ( Directions Direction : Directions . values ( ) )
		{
			SideClosed [ Direction . ordinal ( ) ] = true ;
		}
	}

	public int DisplayList ;

	@Override
	public void invalidate ( )
	{
		if ( worldObj . isRemote )
		{
			Render . ReleaseDisplayList ( DisplayList ) ;
		}

		super . invalidate ( ) ;
	}

	public boolean RenderPattern ;

	@Override
	public void ReadFromNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . ReadFromNbt ( TagCompound ) ;

		if ( TagCompound . hasKey ( "Pattern" ) )
		{
			net . minecraft . nbt . NBTTagList PatternRecord = TagCompound . getTagList ( "Pattern" ) ;

			Pattern = new BlockRecordSet ( ) ;

			int PatternSize = PatternRecord . tagCount ( ) ;

			for ( int Index = 0 ; Index < PatternSize ; Index ++ )
			{
				net . minecraft . nbt . NBTTagCompound PatternBlockRecord = ( net . minecraft . nbt . NBTTagCompound ) PatternRecord . tagAt ( Index ) ;

				Pattern . add ( new BlockRecord ( PatternBlockRecord . getInteger ( "X" ) , PatternBlockRecord . getInteger ( "Y" ) , PatternBlockRecord . getInteger ( "Z" ) ) ) ;
			}
		}
		else
		{
			Pattern = null ;
		}

		RenderPattern = TagCompound . getBoolean ( "RenderPattern" ) ;
	}

	@Override
	public void onDataPacket ( net . minecraft . network . INetworkManager NetworkManager , net . minecraft . network . packet . Packet132TileEntityData Packet )
	{
		super . onDataPacket ( NetworkManager , Packet ) ;

		Render . ReleaseDisplayList ( DisplayList ) ;

		if ( ( Pattern != null ) && RenderPattern )
		{
			DisplayList = Render . InitializeDisplayList ( ) ;

			TemplateCarriagePatternRenderer . FillDisplayList ( this ) ;

			Render . FinalizeDisplayList ( ) ;
		}
	}

	@Override
	public void WriteToNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . WriteToNbt ( TagCompound ) ;

		if ( Pattern != null )
		{
			net . minecraft . nbt . NBTTagList PatternRecord = new net . minecraft . nbt . NBTTagList ( ) ;

			for ( BlockRecord PatternBlock : Pattern )
			{
				net . minecraft . nbt . NBTTagCompound PatternBlockRecord = new net . minecraft . nbt . NBTTagCompound ( ) ;

				PatternBlockRecord . setInteger ( "X" , PatternBlock . X ) ;
				PatternBlockRecord . setInteger ( "Y" , PatternBlock . Y ) ;
				PatternBlockRecord . setInteger ( "Z" , PatternBlock . Z ) ;

				PatternRecord . appendTag ( PatternBlockRecord ) ;
			}

			TagCompound . setTag ( "Pattern" , PatternRecord ) ;
		}

		TagCompound . setBoolean ( "RenderPattern" , RenderPattern ) ;
	}

	@Override
	public void FillPackage ( CarriagePackage Package ) throws CarriageMotionException
	{
		if ( Pattern == null )
		{
			throw ( new CarriageMotionException ( "template carriage has not yet been patterned" ) ) ;
		}

		Package . AddBlock ( Package . AnchorRecord ) ;

		for ( BlockRecord PatternBlock : Pattern )
		{
			BlockRecord Record = new BlockRecord ( PatternBlock . X + xCoord , PatternBlock . Y + yCoord , PatternBlock . Z + zCoord ) ;

			if ( worldObj . isAirBlock ( Record . X , Record . Y , Record . Z ) )
			{
				continue ;
			}

			Record . Identify ( worldObj ) ;

			Package . AddBlock ( Record ) ;

			Package . AddPotentialObstruction ( Record . NextInDirection ( Package . MotionDirection ) ) ;
		}
	}

	@Override
	public net . minecraft . util . AxisAlignedBB getRenderBoundingBox ( )
	{
		return ( INFINITE_EXTENT_AABB ) ;
	}
}
