package JAKJ . RedstoneInMotion ;

public abstract class CarriageEntity extends TileEntity
{
	public boolean [ ] SideClosed = new boolean [ Directions . values ( ) . length ] ;

	public void ToggleSide ( int Side , boolean Sneaking )
	{
		if ( Sneaking )
		{
			Side = Directions . values ( ) [ Side ] . Opposite ( ) . ordinal ( ) ;
		}

		SideClosed [ Side ] = ! SideClosed [ Side ] ;

		WorldUtil . Propagate ( this ) ;
	}

	public int DecorationId ;

	public int DecorationMeta ;

	public void ReadFromNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		for ( int Index = 0 ; Index < SideClosed . length ; Index ++ )
		{
			SideClosed [ Index ] = TagCompound . getBoolean ( "SideClosed" + Index ) ;
		}

		/* TODO : remove */
		if ( TagCompound . hasKey ( "Decoration" ) )
		{
			net . minecraft . item . ItemStack Decoration = net . minecraft . item . ItemStack . loadItemStackFromNBT ( TagCompound . getCompoundTag ( "Decoration" ) ) ;

			DecorationId = Decoration . itemID ;

			DecorationMeta = Decoration . getItem ( ) . getMetadata ( Decoration . getItemDamage ( ) ) ;
		}
		else
		{
			DecorationId = TagCompound . getInteger ( "DecorationId" ) ;

			DecorationMeta = TagCompound . getInteger ( "DecorationMeta" ) ;
		}
	}

	@Override
	public void readFromNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . readFromNBT ( TagCompound ) ;

		ReadFromNbt ( TagCompound ) ;
	}

	@Override
	public void onDataPacket ( net . minecraft . network . INetworkManager NetworkManager , net . minecraft . network . packet . Packet132TileEntityData Packet )
	{
		ReadFromNbt ( Packet . customParam1 ) ;

		WorldUtil . MarkDirtyForClient ( this ) ;
	}

	public void WriteToNbt ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		for ( int Index = 0 ; Index < SideClosed . length ; Index ++ )
		{
			TagCompound . setBoolean ( "SideClosed" + Index , SideClosed [ Index ] ) ;
		}

		TagCompound . setInteger ( "DecorationId" , DecorationId ) ;

		TagCompound . setInteger ( "DecorationMeta" , DecorationMeta ) ;
	}

	@Override
	public void writeToNBT ( net . minecraft . nbt . NBTTagCompound TagCompound )
	{
		super . writeToNBT ( TagCompound ) ;

		WriteToNbt ( TagCompound ) ;
	}

	@Override
	public net . minecraft . network . packet . Packet132TileEntityData getDescriptionPacket ( )
	{
		net . minecraft . network . packet . Packet132TileEntityData Packet = new net . minecraft . network . packet . Packet132TileEntityData ( xCoord , yCoord , zCoord , 0 , new net . minecraft . nbt . NBTTagCompound ( ) ) ;

		WriteToNbt ( Packet . customParam1 ) ;

		return ( Packet ) ;
	}

	public abstract void FillPackage ( CarriagePackage Package ) throws CarriageMotionException ;
}
