package JAKJ . RedstoneInMotion ;

public class Carriage extends net . minecraft . block . Block
{
	public Carriage ( )
	{
		super ( Configuration . BlockIds . Carriage , new net . minecraft . block . material . Material ( wood . blockMaterial . materialMapColor ) ) ;

		setUnlocalizedName ( Core . Handle + "_" + getClass ( ) . getSimpleName ( ) ) ;

		setHardness ( wood . blockHardness ) ;

		setStepSound ( wood . stepSound ) ;

		Registry . RegisterBlock ( this , CarriageItem . class ) ;

		Registry . RegisterHarvestTool ( this , Registry . HarvestToolTypes . Hatchet ) ;

		{
			Registry . RegisterTileEntity ( FrameCarriageEntity . class ) ;

			Registry . RegisterTileEntity ( PlatformCarriageEntity . class ) ;

			Registry . RegisterTileEntity ( StructureCarriageEntity . class ) ;

			Registry . RegisterTileEntity ( SupportCarriageEntity . class ) ;

			Registry . RegisterTileEntity ( TemplateCarriageEntity . class ) ;
		}

		setCreativeTab ( CreativeTab . Instance ) ;
	}

	public enum Types
	{
		Frame ,
		Platform ,
		Structure ,
		Support ,
		Template ;

		public net . minecraft . util . Icon OpenIcon ;

		public net . minecraft . util . Icon ClosedIcon ;
	}

	@Override
	public void getSubBlocks ( int Id , net . minecraft . creativetab . CreativeTabs CreativeTab , java . util . List List )
	{
		for ( Types Type : Types . values ( ) )
		{
			List . add ( Stack . New ( this , Type . ordinal ( ) ) ) ;
		}
	}

	@Override
	public boolean hasTileEntity ( int Meta )
	{
		if ( Meta < 0 )
		{
			return ( false ) ;
		}

		if ( Meta >= Types . values ( ) . length )
		{
			return ( false ) ;
		}

		return ( true ) ;
	}

	@Override
	public net . minecraft . tileentity . TileEntity createTileEntity ( net . minecraft . world . World World , int Meta )
	{
		switch ( Types . values ( ) [ Meta ] )
		{
			case Frame :

				return ( new FrameCarriageEntity ( ) ) ;

			case Platform :

				return ( new PlatformCarriageEntity ( ) ) ;

			case Structure :

				return ( new StructureCarriageEntity ( ) ) ;

			case Support :

				return ( new SupportCarriageEntity ( ) ) ;

			case Template :

				return ( new TemplateCarriageEntity ( ) ) ;
		}

		return ( null ) ;
	}

	@Override
	public void registerIcons ( net . minecraft . client . renderer . texture . IconRegister IconRegister )
	{
		for ( Types Type : Types . values ( ) )
		{
			Type . ClosedIcon = Registry . RegisterIcon ( IconRegister , Type . name ( ) + "Carriage_Closed" ) ;

			Type . OpenIcon = Registry . RegisterIcon ( IconRegister , Type . name ( ) + "Carriage_Open" ) ;
		}
	}

	@Override
	public net . minecraft . util . Icon getIcon ( int Side , int Meta )
	{
		if ( Side != Directions . PosY . ordinal ( ) )
		{
			int DecorationId = Meta >> 8 ;

			if ( DecorationId != 0 )
			{
				int DecorationMeta = ( Meta >> 4 ) & 0xF ;

				return ( net . minecraft . block . Block . blocksList [ DecorationId ] . getIcon ( Side , DecorationMeta ) ) ;
			}
		}

		return ( Types . values ( ) [ Meta & 0xF ] . OpenIcon ) ;
	}

	@Override
	public net . minecraft . util . Icon getBlockTexture ( net . minecraft . world . IBlockAccess World , int X , int Y , int Z , int Side )
	{
		CarriageEntity Carriage = ( CarriageEntity ) World . getBlockTileEntity ( X , Y , Z ) ;

		if ( ( Carriage . DecorationId != 0 ) && ( Carriage . SideClosed [ Side ] ) )
		{
			return ( net . minecraft . block . Block . blocksList [ Carriage . DecorationId ] . getIcon ( Side , Carriage . DecorationMeta ) ) ;
		}

		Types Type = Types . values ( ) [ World . getBlockMetadata ( X , Y , Z ) ] ;

		return ( Carriage . SideClosed [ Side ] ? Type . ClosedIcon : Type . OpenIcon ) ;
	}

	@Override
	public boolean onBlockActivated ( net . minecraft . world . World World , int X , int Y , int Z , net . minecraft . entity . player . EntityPlayer Player , int Side , float HitX , float HitY , float HitZ )
	{
		if ( World . isRemote )
		{
			return ( false ) ;
		}

		if ( ! ToolItemSet . IsScrewdriverOrEquivalent ( Player . inventory . getCurrentItem ( ) ) )
		{
			return ( false ) ;
		}

		( ( CarriageEntity ) World . getBlockTileEntity ( X , Y , Z ) ) . ToggleSide ( Side , Player . isSneaking ( ) ) ;

		return ( true ) ;
	}

	@Override
	public int quantityDropped ( int Meta , int Fortune , java . util . Random Random )
	{
		return ( 0 ) ;
	}

	@Override
	public boolean removeBlockByPlayer ( net . minecraft . world . World World , net . minecraft . entity . player . EntityPlayer Player , int X , int Y , int Z )
	{
		if ( ! World . isRemote )
		{
			if ( ! Player . capabilities . isCreativeMode )
			{
				CarriageEntity Carriage = ( CarriageEntity ) World . getBlockTileEntity ( X , Y , Z ) ;

				int CarriageMeta = World . getBlockMetadata ( X , Y , Z ) ;

				dropBlockAsItem_do ( World , X , Y , Z , Stack . New ( this , ( Carriage . DecorationId << 8 ) | ( Carriage . DecorationMeta << 4 ) | CarriageMeta ) ) ;
			}
		}

		return ( super . removeBlockByPlayer ( World , Player , X , Y , Z ) ) ;
	}

	@Override
	public void onBlockPlacedBy ( net . minecraft . world . World World , int X , int Y , int Z , net . minecraft . entity . EntityLiving Entity , net . minecraft . item . ItemStack Item )
	{
		CarriageEntity Carriage = ( CarriageEntity ) World . getBlockTileEntity ( X , Y , Z ) ;

		Carriage . DecorationId = Item . itemDamage >> 8 ;

		Carriage . DecorationMeta = ( Item . itemDamage >> 4 ) & 0xF ;
	}

	@Override
	public boolean isOpaqueCube ( )
	{
		return ( false ) ;
	}
}
